/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils.paged;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.PaddedAtomicLong;
import org.neo4j.graphalgo.core.utils.paged.PageAllocator;
import org.neo4j.graphalgo.core.utils.paged.PageUtil;
import org.neo4j.graphalgo.core.utils.paged.PagedDataStructure;

public final class ByteArray
extends PagedDataStructure<byte[]> {
    private final AtomicLong allocIdx = new PaddedAtomicLong();
    private static final PageAllocator.Factory<byte[]> ALLOCATOR_FACTORY = PageAllocator.ofArray(byte[].class);

    public static long estimateMemoryUsage(long size) {
        return ALLOCATOR_FACTORY.estimateMemoryUsage(size, ByteArray.class);
    }

    public static ByteArray newArray(long size, AllocationTracker tracker) {
        return new ByteArray(size, ALLOCATOR_FACTORY.newAllocator(tracker));
    }

    private ByteArray(long size, PageAllocator<byte[]> allocator) {
        super(size, allocator);
    }

    public byte get(long index) {
        assert (index < this.capacity());
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        return ((byte[][])this.pages)[pageIndex][indexInPage];
    }

    public int getInt(long index) {
        int indexInPage;
        assert (index < this.capacity());
        int pageIndex = this.pageIndex(index);
        byte[] page = ((byte[][])this.pages)[pageIndex];
        if (page.length - (indexInPage = this.indexInPage(index)) >= 4) {
            return this.getInt(page, indexInPage);
        }
        if (pageIndex + 1 >= ((byte[][])this.pages).length) {
            return -1;
        }
        return this.getInt(page, ((byte[][])this.pages)[pageIndex + 1], indexInPage);
    }

    private int getInt(byte[] page, int offset) {
        return (page[offset] & 0xFF) << 24 | (page[offset + 1] & 0xFF) << 16 | (page[offset + 2] & 0xFF) << 8 | page[offset + 3] & 0xFF;
    }

    private int getInt(byte[] page, byte[] nextPage, int offset) {
        switch (page.length - offset) {
            case 0: {
                return this.getInt(nextPage, 0);
            }
            case 1: {
                return (page[offset] & 0xFF) << 24 | (nextPage[0] & 0xFF) << 16 | (nextPage[1] & 0xFF) << 8 | nextPage[2] & 0xFF;
            }
            case 2: {
                return (page[offset] & 0xFF) << 24 | (page[offset + 1] & 0xFF) << 16 | (nextPage[0] & 0xFF) << 8 | nextPage[1] & 0xFF;
            }
            case 3: {
                return (page[offset] & 0xFF) << 24 | (page[offset + 1] & 0xFF) << 16 | (page[offset + 2] & 0xFF) << 8 | nextPage[0] & 0xFF;
            }
        }
        throw new IllegalArgumentException("wrong boundary");
    }

    public byte set(long index, byte value) {
        assert (index < this.capacity());
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        byte[] page = ((byte[][])this.pages)[pageIndex];
        byte ret = page[indexInPage];
        page[indexInPage] = value;
        return ret;
    }

    public LocalAllocator newAllocator() {
        return new LocalAllocator(this);
    }

    BulkAdder newBulkAdder() {
        return new BulkAdder((byte[][])this.pages, this.pageSize, this.pageShift, this.pageMask);
    }

    public DeltaCursor newCursor() {
        return new DeltaCursor((byte[][])this.pages, this.pageSize, this.pageShift, this.pageMask);
    }

    private long allocate(long numberOfElements, BulkAdder into) {
        long intoIndex = this.allocIdx.getAndAdd(numberOfElements);
        this.grow(intoIndex + numberOfElements);
        into.grow((byte[][])this.pages);
        into.init(intoIndex, numberOfElements);
        return intoIndex;
    }

    public final void skipAllocationRegion(long numberOfElements) {
        this.allocIdx.addAndGet(numberOfElements);
    }

    @Override
    public final long release() {
        return super.release();
    }

    public DeltaCursor deltaCursor(DeltaCursor reuse, long offset) {
        return reuse.init(offset);
    }

    public static final class DeltaCursor
    extends BaseCursor {
        private int currentTarget;
        private int maxTargets;
        private long delta;

        private DeltaCursor(byte[][] pages, int pageSize, int pageShift, int pageMask) {
            super(pages, pageSize, pageShift, pageMask);
        }

        DeltaCursor init(long fromIndex) {
            super.initAll(fromIndex);
            this.next();
            this.currentTarget = 0;
            this.delta = 0L;
            if (this.limit - this.offset >= 4) {
                this.initLength(this.array, this.offset);
            } else {
                this.initLengthSlow();
            }
            return this;
        }

        public long getVLong() {
            if (this.currentTarget++ >= this.maxTargets) {
                return -1L;
            }
            this.delta = this.getVLong0();
            return this.delta;
        }

        private long getVLong0() {
            if (this.limit - this.offset >= 9) {
                return this.getVLong(this.array, this.offset);
            }
            return this.slowGetVLong();
        }

        private void initLength(byte[] array, int offset) {
            this.maxTargets = (array[offset++] & 0xFF) << 24 | (array[offset++] & 0xFF) << 16 | (array[offset++] & 0xFF) << 8 | array[offset++] & 0xFF;
            this.offset = offset;
        }

        private void initLengthSlow() {
            int offset = this.offset;
            int limit = this.limit;
            byte[] page1 = this.array;
            if (!this.next()) {
                return;
            }
            byte[] page2 = this.array;
            int offset2 = this.offset;
            switch (limit - offset) {
                case 0: {
                    this.initLength(page2, offset2);
                    return;
                }
                case 1: {
                    this.maxTargets = (page1[offset] & 0xFF) << 24 | (page2[offset2++] & 0xFF) << 16 | (page2[offset2++] & 0xFF) << 8 | page2[offset2++] & 0xFF;
                    break;
                }
                case 2: {
                    this.maxTargets = (page1[offset++] & 0xFF) << 24 | (page1[offset] & 0xFF) << 16 | (page2[offset2++] & 0xFF) << 8 | page2[offset2++] & 0xFF;
                    break;
                }
                case 3: {
                    this.maxTargets = (page1[offset++] & 0xFF) << 24 | (page1[offset++] & 0xFF) << 16 | (page1[offset] & 0xFF) << 8 | page2[offset2++] & 0xFF;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid boundary");
                }
            }
            this.offset = offset2;
        }

        private long getVLong(byte[] page, int offset) {
            byte b = page[offset++];
            long i = b & 0x7F;
            int shift = 7;
            while ((b & 0x80) != 0) {
                b = page[offset++];
                i |= ((long)b & 0x7FL) << shift;
                shift += 7;
            }
            this.offset = offset;
            return i + this.delta;
        }

        private long slowGetVLong() {
            int diff = this.limit - this.offset;
            if (diff == 0) {
                if (!this.next()) {
                    return -1L;
                }
                return this.getVLong(this.array, this.offset);
            }
            byte[] array = this.array;
            int offset = this.offset;
            byte b = array[offset++];
            long i = b & 0x7F;
            int shift = 7;
            while ((b & 0x80) != 0) {
                if (--diff == 0) {
                    if (!this.next()) {
                        return -1L;
                    }
                    array = this.array;
                    offset = this.offset;
                }
                b = array[offset++];
                i |= ((long)b & 0x7FL) << shift;
                shift += 7;
            }
            this.offset = offset;
            return i + this.delta;
        }
    }

    public static final class BulkAdder
    extends BaseCursor {
        private BulkAdder(byte[][] pages, int pageSize, int pageShift, int pageMask) {
            super(pages, pageSize, pageShift, pageMask);
        }

        @Override
        public final void init(long fromIndex, long length) {
            super.init(fromIndex, length);
            this.next();
        }

        public void addUnsignedInt(int i) {
            if (this.limit - this.offset >= 4) {
                this.quickAddUnsignedInt(i);
            } else {
                this.slowAddUnsignedInt(i);
            }
        }

        public void addVLong(long i) {
            if (this.limit - this.offset >= 9) {
                this.quickAddVLong(i);
            } else {
                this.slowAddVLong(i);
            }
        }

        private void quickAddUnsignedInt(int i) {
            int offset = this.offset;
            byte[] array = this.array;
            array[offset++] = (byte)(i >>> 24);
            array[offset++] = (byte)(i >>> 16);
            array[offset++] = (byte)(i >>> 8);
            array[offset++] = (byte)i;
            this.offset = offset;
        }

        private void slowAddUnsignedInt(int i) {
            byte[] array = this.array;
            int offset = this.offset;
            switch (this.limit - offset) {
                case 0: {
                    if (!this.next()) break;
                    this.quickAddUnsignedInt(i);
                    break;
                }
                case 1: {
                    array[offset++] = (byte)(i >>> 24);
                    if (!this.next()) break;
                    array = this.array;
                    offset = this.offset;
                    array[offset++] = (byte)(i >>> 16);
                    array[offset++] = (byte)(i >>> 8);
                    array[offset++] = (byte)i;
                    break;
                }
                case 2: {
                    array[offset++] = (byte)(i >>> 24);
                    array[offset++] = (byte)(i >>> 16);
                    if (!this.next()) break;
                    array = this.array;
                    offset = this.offset;
                    array[offset++] = (byte)(i >>> 8);
                    array[offset++] = (byte)i;
                    break;
                }
                case 3: {
                    array[offset++] = (byte)(i >>> 24);
                    array[offset++] = (byte)(i >>> 16);
                    array[offset++] = (byte)(i >>> 8);
                    if (!this.next()) break;
                    array = this.array;
                    offset = this.offset;
                    array[offset++] = (byte)i;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid boundaries");
                }
            }
            this.offset = offset;
        }

        private void quickAddVLong(long i) {
            int offset = this.offset;
            byte[] array = this.array;
            while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
                array[offset++] = (byte)(i & 0x7FL | 0x80L);
                i >>>= 7;
            }
            array[offset++] = (byte)i;
            this.offset = offset;
        }

        private void slowAddVLong(long i) {
            int offset = this.offset;
            int limit = this.limit;
            byte[] array = this.array;
            while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
                if (offset >= limit) {
                    if (!this.next()) {
                        return;
                    }
                    array = this.array;
                    offset = this.offset;
                    limit = this.limit;
                    continue;
                }
                array[offset++] = (byte)(i & 0x7FL | 0x80L);
                i >>>= 7;
            }
            this.offset = offset;
            if (offset >= limit && !this.next()) {
                return;
            }
            this.array[this.offset++] = (byte)i;
        }
    }

    public static final class LocalAllocator {
        private static final long PREFETCH_PAGES = 16L;
        private final ByteArray array;
        private final long prefetchSize;
        public final BulkAdder adder;
        private long top;
        private long limit;

        LocalAllocator(ByteArray array) {
            this.array = array;
            this.adder = array.newBulkAdder();
            this.prefetchSize = (long)array.pageSize * 16L;
        }

        public long allocate(long size) {
            long address = this.top;
            if (address + size <= this.limit) {
                this.top += size;
                this.adder.tryNext();
                return address;
            }
            return this.majorAllocate(size);
        }

        private long majorAllocate(long size) {
            long allocate = Math.max(size, this.prefetchSize);
            long address = this.top = this.array.allocate(allocate, this.adder);
            this.limit = this.top + allocate;
            this.top += size;
            return address;
        }
    }

    private static abstract class BaseCursor {
        private byte[][] pages;
        private int numPages;
        private final int pageSize;
        private final int pageShift;
        private final int pageMask;
        public byte[] array;
        public int offset;
        public int limit;
        private long from;
        private long to;
        private long size;
        private int fromPage;
        private int toPage;
        private int currentPage;

        BaseCursor(byte[][] pages, int pageSize, int pageShift, int pageMask) {
            this.pages = pages;
            this.pageSize = pageSize;
            this.pageShift = pageShift;
            this.pageMask = pageMask;
            this.numPages = pages.length;
        }

        void grow(byte[][] pages) {
            this.pages = pages;
            this.numPages = pages.length;
        }

        void init(long fromIndex, long length) {
            this.array = null;
            this.from = fromIndex;
            this.to = fromIndex + length;
            this.size = length;
            this.fromPage = PageUtil.pageIndex(fromIndex, this.pageShift);
            this.toPage = PageUtil.pageIndex(this.to - 1L, this.pageShift);
            this.currentPage = this.fromPage - 1;
        }

        void initAll(long fromIndex) {
            this.array = null;
            this.from = fromIndex;
            this.to = PageUtil.capacityFor(this.numPages, this.pageShift);
            this.size = this.to - fromIndex;
            this.fromPage = PageUtil.pageIndex(fromIndex, this.pageShift);
            this.toPage = this.numPages - 1;
            this.currentPage = this.fromPage - 1;
        }

        public final boolean next() {
            int current;
            if ((current = ++this.currentPage) >= this.pages.length) {
                System.out.println("current = " + current);
            }
            if (current == this.fromPage) {
                this.array = this.pages[current];
                this.offset = PageUtil.indexInPage(this.from, this.pageMask);
                int length = (int)Math.min((long)(this.pageSize - this.offset), this.size);
                this.limit = this.offset + length;
                return true;
            }
            if (current < this.toPage) {
                this.array = this.pages[current];
                this.offset = 0;
                this.limit = this.offset + this.pageSize;
                return true;
            }
            if (current == this.toPage) {
                this.array = this.pages[current];
                this.offset = 0;
                int length = PageUtil.indexInPage(this.to - 1L, this.pageMask) + 1;
                this.limit = this.offset + length;
                return true;
            }
            this.array = null;
            return false;
        }

        final void tryNext() {
            if (this.offset >= this.limit) {
                this.next();
            }
        }
    }
}

