/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils.paged;

import com.carrotsearch.hppc.LongDoubleMap;
import org.neo4j.graphalgo.core.utils.container.TrackingLongDoubleHashMap;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.MemoryUsage;
import org.neo4j.graphalgo.core.utils.paged.PageAllocator;
import org.neo4j.graphalgo.core.utils.paged.PageUtil;
import org.neo4j.graphalgo.core.utils.paged.PagedDataStructure;

public final class HugeLongLongDoubleMap
extends PagedDataStructure<NestedMap> {
    private static final PageAllocator.Factory<NestedMap> ALLOCATOR_FACTORY;

    public static long estimateMemoryUsage(long size) {
        return ALLOCATOR_FACTORY.estimateMemoryUsage(size, HugeLongLongDoubleMap.class);
    }

    public static HugeLongLongDoubleMap newMap(long size, AllocationTracker tracker) {
        return new HugeLongLongDoubleMap(size, ALLOCATOR_FACTORY.newAllocator(tracker));
    }

    private HugeLongLongDoubleMap(long size, PageAllocator<NestedMap> allocator) {
        super(size, allocator);
    }

    public double getOrDefault(long index1, long index2, double defaultValue) {
        assert (index1 < this.capacity());
        int pageIndex = this.pageIndex(index1);
        int indexInPage = this.indexInPage(index1);
        return ((NestedMap[])this.pages)[pageIndex].get(indexInPage, index2, defaultValue);
    }

    public void put(long index1, long index2, double value) {
        assert (index1 < this.capacity());
        int pageIndex = this.pageIndex(index1);
        int indexInPage = this.indexInPage(index1);
        ((NestedMap[])this.pages)[pageIndex].put(indexInPage, index2, value);
    }

    static {
        int pageSize = PageUtil.pageSizeFor(MemoryUsage.BYTES_OBJECT_REF);
        long perNodeUsage = MemoryUsage.shallowSizeOfInstance(TrackingLongDoubleHashMap.class) + MemoryUsage.sizeOfLongArray(33) + MemoryUsage.sizeOfDoubleArray(33);
        long pageUsage = MemoryUsage.shallowSizeOfInstance(NestedMap.class);
        ALLOCATOR_FACTORY = PageAllocator.of(pageSize, pageUsage += perNodeUsage * (long)pageSize, tracker -> new NestedMap(pageSize, tracker), new NestedMap[0]);
    }

    static final class NestedMap {
        private final LongDoubleMap[] page;
        private final AllocationTracker tracker;

        NestedMap(int pageSize, AllocationTracker tracker) {
            this.tracker = tracker;
            this.page = new LongDoubleMap[pageSize];
        }

        double get(int indexInPage, long index2, double defaultValue) {
            LongDoubleMap map = this.page[indexInPage];
            return map != null ? map.getOrDefault(index2, defaultValue) : defaultValue;
        }

        void put(int indexInPage, long index2, double value) {
            this.mapForIndex(indexInPage).put(index2, value);
        }

        private LongDoubleMap mapForIndex(int indexInPage) {
            LongDoubleMap map = this.page[indexInPage];
            if (map == null) {
                map = this.createNewPage(indexInPage);
            }
            return map;
        }

        private synchronized LongDoubleMap createNewPage(int indexInPage) {
            LongDoubleMap map = this.page[indexInPage];
            if (map == null) {
                map = this.page[indexInPage] = new TrackingLongDoubleHashMap(this.tracker);
            }
            return map;
        }
    }
}

