/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils.paged;

import java.util.function.IntSupplier;
import org.neo4j.collection.pool.MarshlandPool;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.PageAllocator;
import org.neo4j.graphalgo.core.utils.paged.PagedDataStructure;

public final class IntArray
extends PagedDataStructure<int[]> {
    private final MarshlandPool<Cursor> cursors = new MarshlandPool(this::newCursor);
    private static final PageAllocator.Factory<int[]> ALLOCATOR_FACTORY = PageAllocator.ofArray(int[].class);

    public static long estimateMemoryUsage(long size) {
        return ALLOCATOR_FACTORY.estimateMemoryUsage(size, IntArray.class);
    }

    public static IntArray newArray(long size, AllocationTracker tracker) {
        return new IntArray(size, ALLOCATOR_FACTORY.newAllocator(tracker));
    }

    private IntArray(long size, PageAllocator<int[]> allocator) {
        super(size, allocator);
    }

    public int get(long index) {
        assert (index < this.capacity());
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        return ((int[][])this.pages)[pageIndex][indexInPage];
    }

    public int set(long index, int value) {
        assert (index < this.capacity());
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        int[] page = ((int[][])this.pages)[pageIndex];
        int ret = page[indexInPage];
        page[indexInPage] = value;
        return ret;
    }

    public int addTo(long index, int value) {
        assert (index < this.capacity());
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        int[] page = ((int[][])this.pages)[pageIndex];
        int n = indexInPage;
        int n2 = page[n] + value;
        page[n] = n2;
        return n2;
    }

    public void or(long index, int value) {
        assert (index < this.capacity());
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        int[] nArray = ((int[][])this.pages)[pageIndex];
        int n = indexInPage;
        nArray[n] = nArray[n] | value;
    }

    public void fill(long fromIndex, long toIndex, IntSupplier value) {
        int toPage;
        assert (fromIndex <= toIndex) : "can only fill positive slice";
        assert (fromIndex < this.capacity());
        assert (toIndex < this.capacity());
        int fromPage = this.pageIndex(fromIndex);
        if (fromPage == (toPage = this.pageIndex(toIndex - 1L))) {
            IntArray.fill(((int[][])this.pages)[fromPage], this.indexInPage(fromIndex), this.indexInPage(toIndex - 1L) + 1, value);
        } else {
            IntArray.fill(((int[][])this.pages)[fromPage], this.indexInPage(fromIndex), this.pageSize, value);
            for (int i = fromPage + 1; i < toPage; ++i) {
                IntArray.fill(((int[][])this.pages)[i], value);
            }
            IntArray.fill(((int[][])this.pages)[toPage], 0, this.indexInPage(toIndex - 1L) + 1, value);
        }
    }

    public BulkAdder newBulkAdder() {
        return new BulkAdder();
    }

    public Cursor newCursor() {
        return new Cursor();
    }

    public Cursor cursorForAll() {
        return this.initCursor(0L, this.size(), (Cursor)this.cursors.acquire());
    }

    public final Cursor cursorFor(long offset, long length) {
        return this.initCursor(offset, length, (Cursor)this.cursors.acquire());
    }

    public final Cursor initCursor(long offset, long length, Cursor reuse) {
        reuse.init(offset, length);
        return reuse;
    }

    @Override
    public final long release() {
        this.cursors.close();
        return super.release();
    }

    public void returnCursor(Cursor cursor) {
        this.cursors.release((Object)cursor);
    }

    private static void fill(int[] array, IntSupplier value) {
        IntArray.fill(array, 0, array.length, value);
    }

    private static void fill(int[] array, int from, int to, IntSupplier value) {
        for (int i = from; i < to; ++i) {
            array[i] = value.getAsInt();
        }
    }

    public final class Cursor
    extends BaseCursor {
        public <E extends Exception> void forEach(IntAction<E> action) throws E {
            int[] array = this.array;
            int limit = this.limit;
            int offset = this.offset;
            while (offset < limit && action.accept(array[offset++])) {
            }
        }
    }

    public final class BulkAdder
    extends BaseCursor {
        @Override
        public final void init(long fromIndex, long length) {
            IntArray.this.grow(fromIndex + length);
            super.init(fromIndex, length);
            this.next();
        }

        public boolean add(int v) {
            int offset;
            if ((offset = this.offset++) < this.limit) {
                this.array[offset] = v;
                return true;
            }
            return this.next() && this.add(v);
        }
    }

    private abstract class BaseCursor {
        public int[] array;
        public int offset;
        public int limit;
        private long from;
        private long to;
        private long size;
        private int fromPage;
        private int toPage;
        private int currentPage;

        private BaseCursor() {
        }

        void init(long fromIndex, long length) {
            this.array = null;
            this.from = fromIndex;
            this.to = fromIndex + length;
            this.size = length;
            this.fromPage = IntArray.this.pageIndex(fromIndex);
            this.toPage = IntArray.this.pageIndex(this.to - 1L);
            this.currentPage = this.fromPage - 1;
            if (this.fromPage > this.toPage) {
                this.fromPage = -1;
            }
        }

        public final boolean next() {
            if (!this.setNext(++this.currentPage, this.fromPage, this.toPage)) {
                this.array = null;
                return false;
            }
            return true;
        }

        private boolean setNext(int current, int from, int to) {
            if (current > to) {
                return false;
            }
            this.setNextInRange(current, from, to);
            return true;
        }

        private void setNextInRange(int current, int from, int to) {
            if (current == from) {
                this.loadFirst(current);
            } else if (current < to) {
                this.loadMiddle(current);
            } else if (current == to) {
                this.loadLast(current);
            }
        }

        private void loadFirst(int current) {
            this.array = ((int[][])IntArray.this.pages)[current];
            this.offset = IntArray.this.indexInPage(this.from);
            int length = (int)Math.min((long)(IntArray.this.pageSize - this.offset), this.size);
            this.limit = this.offset + length;
        }

        private void loadMiddle(int current) {
            this.array = ((int[][])IntArray.this.pages)[current];
            this.offset = 0;
            this.limit = this.offset + IntArray.this.pageSize;
        }

        private void loadLast(int current) {
            this.array = ((int[][])IntArray.this.pages)[current];
            this.offset = 0;
            int length = IntArray.this.indexInPage(this.to - 1L) + 1;
            this.limit = this.offset + length;
        }
    }

    public static interface IntAction<E extends Exception> {
        public boolean accept(int var1) throws E;
    }
}

