/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils.paged;

import java.util.Arrays;
import java.util.function.LongSupplier;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.PageAllocator;
import org.neo4j.graphalgo.core.utils.paged.PagedDataStructure;

public final class LongArray
extends PagedDataStructure<long[]> {
    private static final PageAllocator.Factory<long[]> ALLOCATOR_FACTORY = PageAllocator.ofArray(long[].class);

    public static long estimateMemoryUsage(long size) {
        return ALLOCATOR_FACTORY.estimateMemoryUsage(size, LongArray.class);
    }

    public static LongArray newArray(long size, AllocationTracker tracker) {
        return new LongArray(size, ALLOCATOR_FACTORY.newAllocator(tracker));
    }

    public static LongArray fromPages(long capacity, long[][] pages, AllocationTracker tracker) {
        return new LongArray(capacity, pages, ALLOCATOR_FACTORY.newAllocator(tracker));
    }

    private LongArray(long size, PageAllocator<long[]> allocator) {
        super(size, allocator);
    }

    private LongArray(long capacity, long[][] pages, PageAllocator<long[]> pageAllocator) {
        super(capacity, (T[])pages, pageAllocator);
    }

    public long get(long index) {
        assert (index < this.capacity());
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        return ((long[][])this.pages)[pageIndex][indexInPage];
    }

    public long set(long index, long value) {
        assert (index < this.capacity());
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        long[] page = ((long[][])this.pages)[pageIndex];
        long ret = page[indexInPage];
        page[indexInPage] = value;
        return ret;
    }

    public void or(long index, long value) {
        assert (index < this.capacity());
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        long[] lArray = ((long[][])this.pages)[pageIndex];
        int n = indexInPage;
        lArray[n] = lArray[n] | value;
    }

    public void fill(long value) {
        for (long[] page : (long[][])this.pages) {
            Arrays.fill(page, value);
        }
    }

    public void fill(long fromIndex, long toIndex, LongSupplier value) {
        int toPage;
        assert (fromIndex <= toIndex) : "can only fill positive slice";
        assert (fromIndex < this.capacity());
        assert (toIndex < this.capacity());
        int fromPage = this.pageIndex(fromIndex);
        if (fromPage == (toPage = this.pageIndex(toIndex - 1L))) {
            LongArray.fill(((long[][])this.pages)[fromPage], this.indexInPage(fromIndex), this.indexInPage(toIndex - 1L) + 1, value);
        } else {
            LongArray.fill(((long[][])this.pages)[fromPage], this.indexInPage(fromIndex), this.pageSize, value);
            for (int i = fromPage + 1; i < toPage; ++i) {
                LongArray.fill(((long[][])this.pages)[i], value);
            }
            LongArray.fill(((long[][])this.pages)[toPage], 0, this.indexInPage(toIndex - 1L) + 1, value);
        }
    }

    public Cursor newCursor() {
        return new Cursor(this.size());
    }

    public Cursor cursor(long from, Cursor cursor) {
        cursor.init(from);
        return cursor;
    }

    private static void fill(long[] array, LongSupplier value) {
        LongArray.fill(array, 0, array.length, value);
    }

    private static void fill(long[] array, int from, int to, LongSupplier value) {
        for (int i = from; i < to; ++i) {
            array[i] = value.getAsLong();
        }
    }

    public final class Cursor {
        public long[] array;
        public int offset;
        public int limit;
        private final long to;
        private long from;
        private long size;
        private int fromPage;
        private int toPage;
        private int currentPage;

        private Cursor(long to) {
            this.to = to;
        }

        private void init(long fromIndex) {
            this.array = null;
            this.from = fromIndex;
            this.size = this.to - fromIndex;
            this.toPage = ((long[][])LongArray.this.pages).length - 1;
            this.fromPage = LongArray.this.pageIndex(fromIndex);
            this.currentPage = this.fromPage - 1;
            if (this.fromPage > this.toPage) {
                this.fromPage = -1;
            }
        }

        public final boolean next() {
            int current;
            if ((current = ++this.currentPage) == this.fromPage) {
                this.array = ((long[][])LongArray.this.pages)[current];
                this.offset = LongArray.this.indexInPage(this.from);
                int length = (int)Math.min((long)(LongArray.this.pageSize - this.offset), this.size);
                this.limit = this.offset + length;
            } else if (current < this.toPage) {
                this.array = ((long[][])LongArray.this.pages)[current];
                this.offset = 0;
                this.limit = this.offset + LongArray.this.pageSize;
            } else if (current == this.toPage) {
                this.array = ((long[][])LongArray.this.pages)[current];
                this.offset = 0;
                int length = LongArray.this.indexInPage(this.to - 1L) + 1;
                this.limit = this.offset + length;
            } else {
                this.array = null;
                return false;
            }
            return true;
        }
    }
}

