/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils.paged;

import com.carrotsearch.hppc.ObjectLongIdentityHashMap;
import com.carrotsearch.hppc.ObjectLongMap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import org.neo4j.graphalgo.core.utils.paged.BitUtil;

public final class MemoryUsage {
    private static final int SHIFT_BYTE;
    private static final int SHIFT_CHAR;
    private static final int SHIFT_SHORT;
    private static final int SHIFT_INT;
    private static final int SHIFT_FLOAT;
    private static final int SHIFT_LONG;
    private static final int SHIFT_DOUBLE;
    private static final int SHIFT_OBJECT_REF;
    public static final int BYTES_OBJECT_REF;
    private static final int BYTES_OBJECT_HEADER;
    private static final int BYTES_ARRAY_HEADER;
    private static final int MASK1_OBJECT_ALIGNMENT;
    private static final int MASK2_OBJECT_ALIGNMENT;
    private static final ObjectLongMap<Class<?>> primitiveSizes;
    private static final String MANAGEMENT_FACTORY_CLASS = "java.lang.management.ManagementFactory";
    private static final String HOTSPOT_BEAN_CLASS = "com.sun.management.HotSpotDiagnosticMXBean";

    public static long sizeOfByteArray(int length) {
        return MemoryUsage.alignObjectSize((long)BYTES_ARRAY_HEADER + ((long)length << SHIFT_BYTE));
    }

    public static long sizeOfCharArray(int length) {
        return MemoryUsage.alignObjectSize((long)BYTES_ARRAY_HEADER + ((long)length << SHIFT_CHAR));
    }

    public static long sizeOfShortArray(int length) {
        return MemoryUsage.alignObjectSize((long)BYTES_ARRAY_HEADER + ((long)length << SHIFT_SHORT));
    }

    public static long sizeOfIntArray(int length) {
        return MemoryUsage.alignObjectSize((long)BYTES_ARRAY_HEADER + ((long)length << SHIFT_INT));
    }

    public static long sizeOfFloatArray(int length) {
        return MemoryUsage.alignObjectSize((long)BYTES_ARRAY_HEADER + ((long)length << SHIFT_FLOAT));
    }

    public static long sizeOfLongArray(int length) {
        return MemoryUsage.alignObjectSize((long)BYTES_ARRAY_HEADER + ((long)length << SHIFT_LONG));
    }

    public static long sizeOfDoubleArray(int length) {
        return MemoryUsage.alignObjectSize((long)BYTES_ARRAY_HEADER + ((long)length << SHIFT_DOUBLE));
    }

    public static long sizeOfObjectArray(int length) {
        return MemoryUsage.alignObjectSize((long)BYTES_ARRAY_HEADER + ((long)length << SHIFT_OBJECT_REF));
    }

    public static long sizeOfArray(int length, long bytesPerElement) {
        return MemoryUsage.alignObjectSize((long)BYTES_ARRAY_HEADER + (long)length * bytesPerElement);
    }

    public static long shallowSizeOfInstance(Class<?> clazz) {
        if (clazz.isArray()) {
            throw new IllegalArgumentException("This method does not work with array classes.");
        }
        if (clazz.isPrimitive()) {
            return primitiveSizes.get(clazz);
        }
        long size = BYTES_OBJECT_HEADER;
        while (clazz != null) {
            Field[] fields;
            for (Field f : fields = AccessController.doPrivileged(clazz::getDeclaredFields)) {
                if (Modifier.isStatic(f.getModifiers())) continue;
                size += MemoryUsage.adjustForField(f);
            }
            clazz = clazz.getSuperclass();
        }
        return MemoryUsage.alignObjectSize(size);
    }

    private static long alignObjectSize(long size) {
        return size + (long)MASK1_OBJECT_ALIGNMENT & (long)MASK2_OBJECT_ALIGNMENT;
    }

    private static long adjustForField(Field f) {
        Class<?> type = f.getType();
        if (type.isPrimitive()) {
            return primitiveSizes.get(type);
        }
        return 1 << SHIFT_OBJECT_REF;
    }

    private MemoryUsage() {
        throw new UnsupportedOperationException("No instances");
    }

    static {
        boolean is64Bit;
        SHIFT_BYTE = Integer.numberOfTrailingZeros(1);
        SHIFT_CHAR = Integer.numberOfTrailingZeros(2);
        SHIFT_SHORT = Integer.numberOfTrailingZeros(2);
        SHIFT_INT = Integer.numberOfTrailingZeros(4);
        SHIFT_FLOAT = Integer.numberOfTrailingZeros(4);
        SHIFT_LONG = Integer.numberOfTrailingZeros(8);
        SHIFT_DOUBLE = Integer.numberOfTrailingZeros(8);
        primitiveSizes = new ObjectLongIdentityHashMap();
        primitiveSizes.put(Boolean.TYPE, 1L);
        primitiveSizes.put(Byte.TYPE, 1L);
        primitiveSizes.put(Character.TYPE, 2L);
        primitiveSizes.put(Short.TYPE, 2L);
        primitiveSizes.put(Integer.TYPE, 4L);
        primitiveSizes.put(Float.TYPE, 4L);
        primitiveSizes.put(Double.TYPE, 8L);
        primitiveSizes.put(Long.TYPE, 8L);
        String osArch = System.getProperty("os.arch");
        String x = System.getProperty("sun.arch.data.model");
        if (x != null) {
            is64Bit = x.contains("64");
        } else {
            boolean bl = is64Bit = osArch != null && osArch.contains("64");
        }
        if (is64Bit) {
            int objectAlignment;
            boolean compressedOops;
            block10: {
                compressedOops = false;
                objectAlignment = 8;
                try {
                    Object vmOption2;
                    Class<?> beanClazz = Class.forName(HOTSPOT_BEAN_CLASS);
                    Object hotSpotBean = Class.forName(MANAGEMENT_FACTORY_CLASS).getMethod("getPlatformMXBean", Class.class).invoke(null, beanClazz);
                    if (hotSpotBean == null) break block10;
                    Method getVMOptionMethod = beanClazz.getMethod("getVMOption", String.class);
                    try {
                        vmOption2 = getVMOptionMethod.invoke(hotSpotBean, "UseCompressedOops");
                        compressedOops = Boolean.parseBoolean(vmOption2.getClass().getMethod("getValue", new Class[0]).invoke(vmOption2, new Object[0]).toString());
                    }
                    catch (ReflectiveOperationException | RuntimeException vmOption2) {
                        // empty catch block
                    }
                    try {
                        vmOption2 = getVMOptionMethod.invoke(hotSpotBean, "ObjectAlignmentInBytes");
                        objectAlignment = Integer.parseInt(vmOption2.getClass().getMethod("getValue", new Class[0]).invoke(vmOption2, new Object[0]).toString());
                        objectAlignment = BitUtil.nextHighestPowerOfTwo(objectAlignment);
                    }
                    catch (ReflectiveOperationException | RuntimeException exception) {}
                }
                catch (ReflectiveOperationException | RuntimeException beanClazz) {
                    // empty catch block
                }
            }
            boolean compressedRefsEnabled = compressedOops;
            int bytesObjectAlignment = objectAlignment;
            MASK1_OBJECT_ALIGNMENT = bytesObjectAlignment - 1;
            MASK2_OBJECT_ALIGNMENT = ~MASK1_OBJECT_ALIGNMENT;
            BYTES_OBJECT_REF = compressedRefsEnabled ? 4 : 8;
            SHIFT_OBJECT_REF = Integer.numberOfTrailingZeros(BYTES_OBJECT_REF);
            BYTES_OBJECT_HEADER = 8 + BYTES_OBJECT_REF;
            BYTES_ARRAY_HEADER = (int)MemoryUsage.alignObjectSize(BYTES_OBJECT_HEADER + 4);
        } else {
            int bytesObjectAlignment = 8;
            MASK1_OBJECT_ALIGNMENT = bytesObjectAlignment - 1;
            MASK2_OBJECT_ALIGNMENT = ~MASK1_OBJECT_ALIGNMENT;
            BYTES_OBJECT_REF = 4;
            SHIFT_OBJECT_REF = Integer.numberOfTrailingZeros(BYTES_OBJECT_REF);
            BYTES_OBJECT_HEADER = 8;
            BYTES_ARRAY_HEADER = BYTES_OBJECT_HEADER + 4;
        }
    }
}

