/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils.paged;

import java.lang.reflect.Array;
import java.util.function.Supplier;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.BitUtil;
import org.neo4j.graphalgo.core.utils.paged.MemoryUsage;
import org.neo4j.graphalgo.core.utils.paged.PageUtil;

public abstract class PageAllocator<T> {
    public abstract T newPage();

    public abstract int pageSize();

    public abstract T[] emptyPages();

    public abstract long bytesPerPage();

    public final long estimateMemoryUsage(long size) {
        long numPages = PageUtil.numPagesFor(size, this.pageSize());
        return numPages * this.bytesPerPage();
    }

    public static <T> Factory<T> of(int pageSize, long bytesPerPage, Supplier<T> newPage, T[] emptyPages) {
        return new Factory(pageSize, bytesPerPage, PageAllocator.pageFactory(newPage, bytesPerPage), emptyPages);
    }

    public static <T> Factory<T> of(int pageSize, long bytesPerPage, PageFactory<T> newPage, T[] emptyPages) {
        return new Factory(pageSize, bytesPerPage, newPage, emptyPages);
    }

    public static <T> Factory<T> ofArray(Class<T> arrayClass) {
        Class<?> componentType = arrayClass.getComponentType();
        assert (componentType != null && componentType.isPrimitive());
        long bytesPerElement = MemoryUsage.shallowSizeOfInstance(componentType);
        int pageSize = PageUtil.pageSizeFor((int)bytesPerElement);
        long bytesPerPage = MemoryUsage.sizeOfArray(pageSize, bytesPerElement);
        Object[] emptyPages = (Object[])Array.newInstance(componentType, 0, 0);
        PageFactory<Object> newPage = tracker -> {
            tracker.add(bytesPerPage);
            return Array.newInstance(componentType, pageSize);
        };
        return PageAllocator.of(pageSize, bytesPerPage, newPage, emptyPages);
    }

    private static <T> PageFactory<T> pageFactory(Supplier<T> newPage, long bytesPerPage) {
        return tracker -> {
            tracker.add(bytesPerPage);
            return newPage.get();
        };
    }

    private static final class DirectAllocator<T>
    extends PageAllocator<T> {
        private final PageFactory<T> newPage;
        private final T[] emptyPages;
        private final int pageSize;
        private final long bytesPerPage;

        private DirectAllocator(PageFactory<T> newPage, T[] emptyPages, int pageSize, long bytesPerPage) {
            assert (BitUtil.isPowerOfTwo(pageSize));
            this.emptyPages = emptyPages;
            this.newPage = newPage;
            this.pageSize = pageSize;
            this.bytesPerPage = bytesPerPage;
        }

        @Override
        public T newPage() {
            return this.newPage.newPage();
        }

        @Override
        public int pageSize() {
            return this.pageSize;
        }

        @Override
        public long bytesPerPage() {
            return this.bytesPerPage;
        }

        @Override
        public T[] emptyPages() {
            return this.emptyPages;
        }
    }

    private static final class TrackingAllocator<T>
    extends PageAllocator<T> {
        private final PageFactory<T> newPage;
        private final T[] emptyPages;
        private final int pageSize;
        private final long bytesPerPage;
        private final AllocationTracker tracker;

        private TrackingAllocator(PageFactory<T> newPage, T[] emptyPages, int pageSize, long bytesPerPage, AllocationTracker tracker) {
            this.emptyPages = emptyPages;
            assert (BitUtil.isPowerOfTwo(pageSize));
            this.newPage = newPage;
            this.pageSize = pageSize;
            this.bytesPerPage = bytesPerPage;
            this.tracker = tracker;
        }

        @Override
        public T newPage() {
            return this.newPage.newPage(this.tracker);
        }

        @Override
        public int pageSize() {
            return this.pageSize;
        }

        @Override
        public long bytesPerPage() {
            return this.bytesPerPage;
        }

        @Override
        public T[] emptyPages() {
            return this.emptyPages;
        }
    }

    @FunctionalInterface
    public static interface PageFactory<T> {
        public T newPage(AllocationTracker var1);

        default public T newPage() {
            return this.newPage(AllocationTracker.EMPTY);
        }
    }

    public static final class Factory<T> {
        private final int pageSize;
        private final long bytesPerPage;
        private final PageFactory<T> newPage;
        private final T[] emptyPages;

        private Factory(int pageSize, long bytesPerPage, PageFactory<T> newPage, T[] emptyPages) {
            this.pageSize = pageSize;
            this.bytesPerPage = bytesPerPage;
            this.newPage = newPage;
            this.emptyPages = emptyPages;
        }

        public long estimateMemoryUsage(long size) {
            long numPages = PageUtil.numPagesFor(size, this.pageSize);
            return numPages * this.bytesPerPage;
        }

        public long estimateMemoryUsage(long size, Class<?> container) {
            return MemoryUsage.shallowSizeOfInstance(container) + this.estimateMemoryUsage(size);
        }

        int pageSize() {
            return this.pageSize;
        }

        PageAllocator<T> newAllocator(AllocationTracker tracker) {
            if (AllocationTracker.isTracking(tracker)) {
                return new TrackingAllocator(this.newPage, this.emptyPages, this.pageSize, this.bytesPerPage, tracker);
            }
            return new DirectAllocator(this.newPage, this.emptyPages, this.pageSize, this.bytesPerPage);
        }
    }
}

