/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils.paged;

import org.neo4j.graphalgo.core.utils.paged.BitUtil;

public final class PageUtil {
    private static final int PAGE_SIZE_IN_BYTES = 32768;

    public static int pageSizeFor(int sizeOfElement) {
        assert (BitUtil.isPowerOfTwo(sizeOfElement));
        return 32768 >> Integer.numberOfTrailingZeros(sizeOfElement);
    }

    static int numPagesFor(long capacity, int pageSize) {
        int pageShift = Integer.numberOfTrailingZeros(pageSize);
        int pageMask = pageSize - 1;
        return PageUtil.numPagesFor(capacity, pageShift, pageMask);
    }

    static int numPagesFor(long capacity, int pageShift, int pageMask) {
        long numPages = capacity + (long)pageMask >>> pageShift;
        assert (numPages <= Integer.MAX_VALUE) : "pageSize=" + (pageMask + 1) + " is too small for such as capacity: " + capacity;
        return (int)numPages;
    }

    static long capacityFor(int numPages, int pageShift) {
        return (long)numPages << pageShift;
    }

    public static int pageIndex(long index, int pageShift) {
        return (int)(index >>> pageShift);
    }

    public static int indexInPage(long index, int pageMask) {
        return (int)(index & (long)pageMask);
    }

    private PageUtil() {
        throw new UnsupportedOperationException("No instances");
    }
}

