/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils.paged;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.util.ArrayUtil;
import org.neo4j.graphalgo.core.utils.paged.MemoryUsage;
import org.neo4j.graphalgo.core.utils.paged.PaddedAtomicLong;
import org.neo4j.graphalgo.core.utils.paged.PageAllocator;
import org.neo4j.graphalgo.core.utils.paged.PageUtil;

public class PagedDataStructure<T> {
    final int pageSize;
    final int pageShift;
    final int pageMask;
    private final long maxSupportedSize;
    volatile T[] pages;
    private final AtomicLong size = new PaddedAtomicLong();
    private final AtomicLong capacity = new PaddedAtomicLong();
    private final ReentrantLock growLock = new ReentrantLock(true);
    private final PageAllocator<T> allocator;

    PagedDataStructure(long size, PageAllocator<T> allocator) {
        this.pageSize = allocator.pageSize();
        this.pageShift = Integer.numberOfTrailingZeros(this.pageSize);
        this.pageMask = this.pageSize - 1;
        int maxIndexShift = 31 + this.pageShift;
        this.maxSupportedSize = 1L << maxIndexShift;
        assert (size <= this.maxSupportedSize);
        this.size.set(size);
        this.allocator = allocator;
        this.pages = allocator.emptyPages();
        this.setPages(this.numPages(size), 0);
    }

    PagedDataStructure(long size, T[] pages, PageAllocator<T> allocator) {
        this.pageSize = allocator.pageSize();
        this.pageShift = Integer.numberOfTrailingZeros(this.pageSize);
        this.pageMask = this.pageSize - 1;
        if (this.numPages(size) != pages.length) {
            throw new IllegalArgumentException(String.format("The capacity of [%d] would require [%d] pages, but [%d] were provided", size, this.numPages(size), pages.length));
        }
        int maxIndexShift = 31 + this.pageShift;
        this.maxSupportedSize = 1L << maxIndexShift;
        this.allocator = allocator;
        this.pages = pages;
        this.capacity.set(this.capacityFor(pages.length));
        this.size.set(size);
    }

    public final long size() {
        return this.size.get();
    }

    public final long capacity() {
        return this.capacity.get();
    }

    public long release() {
        this.size.set(0L);
        long freed = this.allocator.estimateMemoryUsage(this.capacity.getAndSet(0L));
        this.pages = null;
        return freed;
    }

    private int numPages(long capacity) {
        return PageUtil.numPagesFor(capacity, this.pageShift, this.pageMask);
    }

    final long capacityFor(int numPages) {
        return (long)numPages << this.pageShift;
    }

    final int pageIndex(long index) {
        return (int)(index >>> this.pageShift);
    }

    final int indexInPage(long index) {
        return (int)(index & (long)this.pageMask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void grow(long newSize) {
        assert (newSize <= this.maxSupportedSize);
        long cap = this.capacity.get();
        if (cap >= newSize) {
            this.growSize(newSize);
            return;
        }
        this.growLock.lock();
        try {
            cap = this.capacity.get();
            if (cap >= newSize) {
                this.growSize(newSize);
                return;
            }
            int numPages = ArrayUtil.oversize((int)this.numPages(newSize), (int)MemoryUsage.BYTES_OBJECT_REF);
            this.setPages(numPages, this.pages.length);
            this.growSize(newSize);
        }
        finally {
            this.growLock.unlock();
        }
    }

    private void growSize(long newSize) {
        long size;
        while ((size = this.size.get()) < newSize && !this.size.compareAndSet(size, newSize)) {
        }
    }

    private void setPages(int numPages, int currentNumPages) {
        T[] pages = Arrays.copyOf(this.pages, numPages);
        for (int i = currentNumPages; i < numPages; ++i) {
            pages[i] = this.allocateNewPage();
        }
        this.pages = pages;
        this.capacity.set(this.capacityFor(numPages));
    }

    T allocateNewPage() {
        return this.allocator.newPage();
    }
}

