/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils.paged;

import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.PageAllocator;
import org.neo4j.graphalgo.core.utils.paged.PageUtil;
import org.neo4j.graphalgo.core.utils.paged.PagedDataStructure;

public final class SparseLongArray
extends PagedDataStructure<long[]> {
    public static final long NOT_FOUND = -1L;
    private static final PageAllocator.Factory<long[]> ALLOCATOR_FACTORY = PageAllocator.ofArray(long[].class);

    public static long estimateMemoryUsage(long size) {
        return ALLOCATOR_FACTORY.estimateMemoryUsage(size, SparseLongArray.class);
    }

    public static SparseLongArray newArray(long size, AllocationTracker tracker) {
        int numPages = PageUtil.numPagesFor(size, ALLOCATOR_FACTORY.pageSize());
        return SparseLongArray.fromPages(size, new long[numPages][], tracker);
    }

    public static SparseLongArray fromPages(long capacity, long[][] pages, AllocationTracker tracker) {
        return new SparseLongArray(capacity, pages, ALLOCATOR_FACTORY.newAllocator(tracker));
    }

    private SparseLongArray(long capacity, long[][] pages, PageAllocator<long[]> pageAllocator) {
        super(capacity, (T[])pages, pageAllocator);
    }

    public long get(long index) {
        assert (index < this.capacity());
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        long[] page = ((long[][])this.pages)[pageIndex];
        return page == null ? -1L : page[indexInPage] & Long.MAX_VALUE;
    }

    public void set(long index, long value) {
        assert (index < this.capacity());
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        long[] page = ((long[][])this.pages)[pageIndex];
        if (page == null) {
            page = (long[])this.allocateNewPage();
            ((long[][])this.pages)[pageIndex] = page;
        }
        page[indexInPage] = value;
    }

    public boolean contains(long index) {
        assert (index < this.capacity());
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        long[] page = ((long[][])this.pages)[pageIndex];
        return page != null && page[indexInPage] != 0L;
    }
}

