/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils.queue;

import com.carrotsearch.hppc.IntDoubleScatterMap;
import org.neo4j.graphalgo.core.utils.queue.IntPriorityQueue;

public final class IntMaxPriorityQueue
extends IntPriorityQueue {
    private static final int[] EMPTY_INT = new int[0];
    private final IntDoubleScatterMap costs;

    public IntMaxPriorityQueue() {
        this(14);
    }

    public IntMaxPriorityQueue(int initialCapacity) {
        super(initialCapacity);
        this.costs = new IntDoubleScatterMap(initialCapacity);
    }

    @Override
    protected boolean lessThan(int a, int b) {
        return this.costs.get(a) > this.costs.get(b);
    }

    @Override
    protected void addCost(int element, double cost) {
        this.costs.put(element, cost);
    }

    @Override
    protected double cost(int element) {
        return this.costs.get(element);
    }

    @Override
    public void release() {
        super.release();
        this.costs.keys = EMPTY_INT;
        this.costs.clear();
        this.costs.keys = null;
        this.costs.values = null;
    }
}

