/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils.queue;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.neo4j.collection.primitive.PrimitiveIntIterable;
import org.neo4j.collection.primitive.PrimitiveIntIterator;

public abstract class IntPriorityQueue
implements PrimitiveIntIterable {
    public static final int DEFAULT_CAPACITY = 14;
    private int[] heap;
    private int size = 0;

    protected IntPriorityQueue() {
        this(14);
    }

    protected IntPriorityQueue(int initialCapacity) {
        int heapSize = 0 == initialCapacity ? 2 : initialCapacity + 1;
        this.heap = new int[ArrayUtil.oversize((int)heapSize, (int)4)];
    }

    protected abstract boolean lessThan(int var1, int var2);

    protected abstract void addCost(int var1, double var2);

    protected abstract double cost(int var1);

    protected void elementRemoved(int element) {
    }

    public final int add(int element, double cost) {
        this.addCost(element, cost);
        ++this.size;
        this.ensureCapacityForInsert();
        this.heap[this.size] = element;
        this.upHeap(this.size);
        return this.heap[1];
    }

    public final int top() {
        return this.heap[1];
    }

    public final double topCost() {
        return this.cost(this.top());
    }

    public final int pop() {
        if (this.size > 0) {
            int result = this.heap[1];
            this.heap[1] = this.heap[this.size];
            --this.size;
            this.downHeap(1);
            this.elementRemoved(result);
            return result;
        }
        return -1;
    }

    public final int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final boolean nonEmpty() {
        return this.size != 0;
    }

    public void clear() {
        this.size = 0;
    }

    public void release() {
        this.size = 0;
        this.heap = null;
    }

    private boolean upHeap(int origPos) {
        int i = origPos;
        int node = this.heap[i];
        for (int j = i >>> 1; j > 0 && this.lessThan(node, this.heap[j]); j >>>= 1) {
            this.heap[i] = this.heap[j];
            i = j;
        }
        this.heap[i] = node;
        return i != origPos;
    }

    private void downHeap(int i) {
        int node = this.heap[i];
        int j = i << 1;
        int k = j + 1;
        if (k <= this.size && this.lessThan(this.heap[k], this.heap[j])) {
            j = k;
        }
        while (j <= this.size && this.lessThan(this.heap[j], node)) {
            this.heap[i] = this.heap[j];
            i = j;
            k = (j = i << 1) + 1;
            if (k > this.size || !this.lessThan(this.heap[k], this.heap[j])) continue;
            j = k;
        }
        this.heap[i] = node;
    }

    private void ensureCapacityForInsert() {
        if (this.size >= this.heap.length) {
            this.heap = Arrays.copyOf(this.heap, ArrayUtil.oversize((int)(this.size + 1), (int)4));
        }
    }

    public PrimitiveIntIterator iterator() {
        return new PrimitiveIntIterator(){
            int i = 1;

            public boolean hasNext() {
                return this.i <= IntPriorityQueue.this.size;
            }

            public int next() {
                return IntPriorityQueue.this.heap[this.i++];
            }
        };
    }
}

