/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils.queue;

import com.carrotsearch.hppc.LongDoubleScatterMap;
import java.util.NoSuchElementException;
import org.apache.lucene.util.ArrayUtil;
import org.neo4j.collection.primitive.PrimitiveLongIterable;
import org.neo4j.collection.primitive.PrimitiveLongIterator;

public final class LongMinPriorityQueue
implements PrimitiveLongIterable {
    private static final int DEFAULT_CAPACITY = 14;
    private int size = 0;
    private long[] heap;
    private final LongDoubleScatterMap costs;

    public LongMinPriorityQueue() {
        this(14);
    }

    public LongMinPriorityQueue(int initialCapacity) {
        int heapSize = 0 == initialCapacity ? 2 : initialCapacity + 1;
        this.heap = new long[ArrayUtil.oversize((int)heapSize, (int)4)];
        this.costs = new LongDoubleScatterMap(heapSize);
    }

    private boolean lessThan(long a, long b) {
        return this.costs.get(a) < this.costs.get(b);
    }

    public long add(long element, double cost) {
        ++this.size;
        this.ensureCapacityForInsert();
        this.heap[this.size] = element;
        this.costs.put(element, cost);
        this.upHeap(this.size);
        return this.heap[1];
    }

    public double getCost(long element) {
        return this.costs.get(element);
    }

    public long top() {
        return this.heap[1];
    }

    public double topCost() {
        return this.costs.get(this.top());
    }

    public long pop() {
        if (this.size > 0) {
            long result = this.heap[1];
            this.heap[1] = this.heap[this.size];
            --this.size;
            this.downHeap(1);
            this.costs.remove(result);
            return result;
        }
        return -1L;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean nonEmpty() {
        return this.size != 0;
    }

    public void clear() {
        this.size = 0;
    }

    public void release() {
        this.size = 0;
        this.heap = null;
        this.costs.keys = new long[0];
        this.costs.clear();
        this.costs.keys = null;
        this.costs.values = null;
    }

    private boolean upHeap(int origPos) {
        int i = origPos;
        long node = this.heap[i];
        for (int j = i >>> 1; j > 0 && this.lessThan(node, this.heap[j]); j >>>= 1) {
            this.heap[i] = this.heap[j];
            i = j;
        }
        this.heap[i] = node;
        return i != origPos;
    }

    private void downHeap(int i) {
        long node = this.heap[i];
        int j = i << 1;
        int k = j + 1;
        if (k <= this.size && this.lessThan(this.heap[k], this.heap[j])) {
            j = k;
        }
        while (j <= this.size && this.lessThan(this.heap[j], node)) {
            this.heap[i] = this.heap[j];
            i = j;
            k = (j = i << 1) + 1;
            if (k > this.size || !this.lessThan(this.heap[k], this.heap[j])) continue;
            j = k;
        }
        this.heap[i] = node;
    }

    private void ensureCapacityForInsert() {
        if (this.size >= this.heap.length) {
            long[] newHeap = new long[ArrayUtil.oversize((int)(this.size + 1), (int)4)];
            System.arraycopy(this.heap, 0, newHeap, 0, this.heap.length);
            this.heap = newHeap;
        }
    }

    public PrimitiveLongIterator iterator() {
        return new PrimitiveLongIterator(){
            int i = 1;

            public boolean hasNext() {
                return this.i <= LongMinPriorityQueue.this.size;
            }

            public long next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return LongMinPriorityQueue.this.heap[this.i++];
            }
        };
    }
}

