/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.write;

import org.neo4j.kernel.api.properties.DefinedProperty;

public interface PropertyTranslator<T> {
    public DefinedProperty toProperty(int var1, T var2, long var3);

    public static interface OfOptionalInt<T>
    extends PropertyTranslator<T> {
        public int toInt(T var1, long var2);

        @Override
        default public DefinedProperty toProperty(int propertyId, T data, long nodeId) {
            int value = this.toInt(data, nodeId);
            if (value >= 0) {
                return DefinedProperty.intProperty((int)propertyId, (int)value);
            }
            return null;
        }
    }

    public static interface OfInt<T>
    extends PropertyTranslator<T> {
        public int toInt(T var1, long var2);

        @Override
        default public DefinedProperty toProperty(int propertyId, T data, long nodeId) {
            int value = this.toInt(data, nodeId);
            return DefinedProperty.intProperty((int)propertyId, (int)value);
        }
    }

    public static interface OfOptionalDouble<T>
    extends PropertyTranslator<T> {
        public double toDouble(T var1, long var2);

        @Override
        default public DefinedProperty toProperty(int propertyId, T data, long nodeId) {
            double value = this.toDouble(data, nodeId);
            if (value >= 0.0) {
                return DefinedProperty.doubleProperty((int)propertyId, (double)value);
            }
            return null;
        }
    }

    public static interface OfDouble<T>
    extends PropertyTranslator<T> {
        public double toDouble(T var1, long var2);

        @Override
        default public DefinedProperty toProperty(int propertyId, T data, long nodeId) {
            return DefinedProperty.doubleProperty((int)propertyId, (double)this.toDouble(data, nodeId));
        }
    }
}

