/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.logging.Log;

public abstract class Algorithm<ME extends Algorithm<ME>>
implements TerminationFlag {
    private ProgressLogger progressLogger = ProgressLogger.NULL_LOGGER;
    private TerminationFlag terminationFlag = TerminationFlag.RUNNING_TRUE;

    public abstract ME me();

    public abstract ME release();

    public ME withLog(Log log) {
        return this.withProgressLogger(ProgressLogger.wrap(log, this.getClass().getSimpleName()));
    }

    public ME withProgressLogger(ProgressLogger progressLogger) {
        this.progressLogger = progressLogger;
        return this.me();
    }

    public ME withTerminationFlag(TerminationFlag terminationFlag) {
        this.terminationFlag = terminationFlag;
        return this.me();
    }

    public TerminationFlag getTerminationFlag() {
        return this.terminationFlag;
    }

    public ProgressLogger getProgressLogger() {
        return this.progressLogger;
    }

    @Override
    public boolean running() {
        return this.terminationFlag.running();
    }
}

