/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.queue.IntMinPriorityQueue;
import org.neo4j.graphalgo.impl.MSBFSASPAlgorithm;
import org.neo4j.graphdb.Direction;

public class AllShortestPaths
extends MSBFSASPAlgorithm<AllShortestPaths> {
    private Graph graph;
    private final int nodeCount;
    private final int concurrency;
    private AtomicInteger counter;
    private ExecutorService executorService;
    private BlockingQueue<Result> resultQueue;
    private volatile boolean outputStreamOpen;

    public AllShortestPaths(Graph graph, ExecutorService executorService, int concurrency) {
        this.graph = graph;
        this.nodeCount = Math.toIntExact(graph.nodeCount());
        this.executorService = executorService;
        if (concurrency < 1) {
            throw new IllegalArgumentException("concurrency must be >0");
        }
        this.concurrency = concurrency;
        this.counter = new AtomicInteger();
        this.resultQueue = new LinkedBlockingQueue<Result>();
    }

    @Override
    public Stream<Result> resultStream() {
        this.counter.set(0);
        this.outputStreamOpen = true;
        for (int i2 = 0; i2 < this.concurrency; ++i2) {
            this.executorService.submit(new ShortestPathTask());
        }
        long end = (long)this.nodeCount * (long)this.nodeCount;
        return ((LongStream)LongStream.range(0L, end).onClose(() -> {
            this.outputStreamOpen = false;
        })).mapToObj(i -> {
            try {
                return this.resultQueue.take();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }).filter(result -> result.distance != Double.POSITIVE_INFINITY);
    }

    @Override
    public AllShortestPaths me() {
        return this;
    }

    @Override
    public AllShortestPaths release() {
        this.graph = null;
        this.counter = null;
        this.resultQueue = null;
        return this;
    }

    public static class Result {
        public final long sourceNodeId;
        public final long targetNodeId;
        public final double distance;

        public Result(long sourceNodeId, long targetNodeId, double distance) {
            this.sourceNodeId = sourceNodeId;
            this.targetNodeId = targetNodeId;
            this.distance = distance;
        }

        public String toString() {
            return "Result{sourceNodeId=" + this.sourceNodeId + ", targetNodeId=" + this.targetNodeId + ", distance=" + this.distance + '}';
        }
    }

    private class ShortestPathTask
    implements Runnable {
        private final IntMinPriorityQueue queue;
        private final double[] distance;

        private ShortestPathTask() {
            this.distance = new double[AllShortestPaths.this.nodeCount];
            this.queue = new IntMinPriorityQueue();
        }

        @Override
        public void run() {
            int startNode;
            ProgressLogger progressLogger = AllShortestPaths.this.getProgressLogger();
            while (AllShortestPaths.this.outputStreamOpen && AllShortestPaths.this.running() && (startNode = AllShortestPaths.this.counter.getAndIncrement()) < AllShortestPaths.this.nodeCount) {
                this.compute(startNode);
                for (int i = 0; i < AllShortestPaths.this.nodeCount; ++i) {
                    Result result = new Result(AllShortestPaths.this.graph.toOriginalNodeId(startNode), AllShortestPaths.this.graph.toOriginalNodeId(i), this.distance[i]);
                    try {
                        AllShortestPaths.this.resultQueue.put(result);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                progressLogger.logProgress((double)startNode / (double)(AllShortestPaths.this.nodeCount - 1));
            }
        }

        public void compute(int startNode) {
            Arrays.fill(this.distance, Double.POSITIVE_INFINITY);
            this.distance[startNode] = 0.0;
            this.queue.add(startNode, 0.0);
            while (AllShortestPaths.this.outputStreamOpen && !this.queue.isEmpty()) {
                int node = this.queue.pop();
                double sourceDistance = this.distance[node];
                AllShortestPaths.this.graph.forEachRelationship(node, Direction.OUTGOING, (source, target, relId, weight) -> {
                    double targetDistance = weight + sourceDistance;
                    if (targetDistance < this.distance[target]) {
                        this.distance[target] = targetDistance;
                        this.queue.add(target, targetDistance);
                    }
                    return true;
                });
            }
        }
    }
}

