/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import com.carrotsearch.hppc.IntArrayDeque;
import com.carrotsearch.hppc.IntStack;
import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.utils.container.Path;
import org.neo4j.graphalgo.impl.Algorithm;
import org.neo4j.graphdb.Direction;

public class BetweennessCentrality
extends Algorithm<BetweennessCentrality> {
    private Graph graph;
    private double[] centrality;
    private double[] delta;
    private int[] sigma;
    private int[] distance;
    private IntStack stack;
    private IntArrayDeque queue;
    private Path[] paths;
    private int nodeCount;
    private Direction direction = Direction.OUTGOING;
    private double divisor = 1.0;

    public BetweennessCentrality(Graph graph) {
        this.graph = graph;
        this.nodeCount = Math.toIntExact(graph.nodeCount());
        this.centrality = new double[this.nodeCount];
        this.stack = new IntStack();
        this.sigma = new int[this.nodeCount];
        this.distance = new int[this.nodeCount];
        this.queue = new IntArrayDeque();
        this.paths = new Path[this.nodeCount];
        this.delta = new double[this.nodeCount];
    }

    public BetweennessCentrality withDirection(Direction direction) {
        this.direction = direction;
        this.divisor = direction == Direction.BOTH ? 2.0 : 1.0;
        return this;
    }

    public BetweennessCentrality compute() {
        Arrays.fill(this.centrality, 0.0);
        this.graph.forEachNode(this::compute);
        return this;
    }

    public double[] getCentrality() {
        return this.centrality;
    }

    public void forEach(ResultConsumer consumer) {
        for (int i = this.nodeCount - 1; i >= 0; --i) {
            if (consumer.consume(this.graph.toOriginalNodeId(i), this.centrality[i])) continue;
            return;
        }
    }

    public Stream<Result> resultStream() {
        return IntStream.range(0, this.nodeCount).mapToObj(nodeId -> new Result(this.graph.toOriginalNodeId(nodeId), this.centrality[nodeId]));
    }

    private boolean compute(int startNode) {
        int node;
        this.clearPaths();
        this.stack.clear();
        this.queue.clear();
        Arrays.fill(this.sigma, 0);
        Arrays.fill(this.delta, 0.0);
        Arrays.fill(this.distance, -1);
        this.sigma[startNode] = 1;
        this.distance[startNode] = 0;
        this.queue.addLast(startNode);
        while (!this.queue.isEmpty() && this.running()) {
            node = this.queue.removeFirst();
            this.stack.push(node);
            this.graph.forEachRelationship(node, this.direction, (source, target, relationId) -> {
                if (this.distance[target] < 0) {
                    this.queue.addLast(target);
                    this.distance[target] = this.distance[node] + 1;
                }
                if (this.distance[target] == this.distance[node] + 1) {
                    int n = target;
                    this.sigma[n] = this.sigma[n] + this.sigma[node];
                    this.append(target, node);
                }
                return true;
            });
        }
        while (!this.stack.isEmpty() && this.running()) {
            node = this.stack.pop();
            if (null == this.paths[node]) continue;
            this.paths[node].forEach((int v) -> {
                int n = v;
                this.delta[n] = this.delta[n] + (double)this.sigma[v] / (double)this.sigma[node] * (this.delta[node] + 1.0);
                return true;
            });
            if (node == startNode) continue;
            int n = node;
            this.centrality[n] = this.centrality[n] + this.delta[node] / this.divisor;
        }
        this.getProgressLogger().logProgress((double)startNode / (double)(this.nodeCount - 1));
        return true;
    }

    private void append(int path, int nodeId) {
        if (null == this.paths[path]) {
            this.paths[path] = new Path();
        }
        this.paths[path].append(nodeId);
    }

    private void clearPaths() {
        for (Path path : this.paths) {
            if (null == path) continue;
            path.clear();
        }
    }

    @Override
    public BetweennessCentrality me() {
        return this;
    }

    @Override
    public BetweennessCentrality release() {
        this.graph = null;
        this.centrality = null;
        this.delta = null;
        this.sigma = null;
        this.distance = null;
        this.stack = null;
        this.queue = null;
        this.paths = null;
        return this;
    }

    public static final class Result {
        public final long nodeId;
        public final double centrality;

        public Result(long nodeId, double centrality) {
            this.nodeId = nodeId;
            this.centrality = centrality;
        }

        public String toString() {
            return "Result{nodeId=" + this.nodeId + ", centrality=" + this.centrality + '}';
        }
    }

    public static interface ResultConsumer {
        public boolean consume(long var1, double var3);
    }
}

