/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.utils.AtomicDoubleArray;
import org.neo4j.graphalgo.core.utils.ParallelUtil;
import org.neo4j.graphalgo.core.utils.Pools;
import org.neo4j.graphalgo.core.utils.container.MultiQueue;
import org.neo4j.graphalgo.impl.Algorithm;
import org.neo4j.graphalgo.impl.BetweennessCentrality;
import org.neo4j.graphdb.Direction;

public class BetweennessCentralitySuccessorBrandes
extends Algorithm<BetweennessCentralitySuccessorBrandes> {
    private Graph graph;
    private AtomicDoubleArray centrality;
    private int nodeCount;
    private ExecutorService executorService;
    private AtomicIntegerArray sigma;
    private AtomicIntegerArray d;
    private double[] delta;
    private AtomicInteger count;
    private int phase;
    private MultiQueue successors;
    private MultiQueue phaseQueue;
    private ArrayList<Future<?>> futures = new ArrayList();
    private Direction direction = Direction.OUTGOING;

    public BetweennessCentralitySuccessorBrandes(Graph graph, double scaleFactor, ExecutorService executorService) {
        this.graph = graph;
        this.nodeCount = Math.toIntExact(graph.nodeCount());
        this.executorService = executorService;
        this.centrality = new AtomicDoubleArray(this.nodeCount, scaleFactor);
        this.sigma = new AtomicIntegerArray(this.nodeCount);
        this.delta = new double[this.nodeCount];
        this.d = new AtomicIntegerArray(this.nodeCount);
        this.successors = new MultiQueue(executorService, this.nodeCount);
        this.phaseQueue = new MultiQueue(executorService, this.nodeCount);
        this.count = new AtomicInteger();
    }

    public BetweennessCentralitySuccessorBrandes compute() {
        this.graph.forEachNode(this::compute);
        if (this.direction == Direction.BOTH) {
            ParallelUtil.iterateParallel(this.executorService, this.nodeCount, Pools.DEFAULT_CONCURRENCY, i -> this.centrality.set(i, this.centrality.get(i) / 2.0));
        }
        return this;
    }

    public BetweennessCentralitySuccessorBrandes withDirection(Direction direction) {
        this.direction = direction;
        return this;
    }

    private boolean compute(int startNodeId) {
        AtomicIntegerArray offsets = this.phaseQueue.getOffsets();
        ParallelUtil.iterateParallel(this.executorService, this.nodeCount, 4, i -> {
            this.d.set(i, -1);
            this.sigma.set(i, 0);
            offsets.set(i, 0);
        });
        this.phaseQueue.addOrCreate(0, startNodeId);
        this.d.set(startNodeId, 0);
        this.sigma.set(startNodeId, 1);
        this.phase = 0;
        this.count.set(1);
        while (this.count.getAndSet(0) > 0 && this.running()) {
            this.futures.clear();
            this.phaseQueue.forEach(this.futures, this.phase, v -> {
                this.successors.clear(v);
                this.graph.forEachRelationship(v, this.direction, (sourceNodeId, w, relationId) -> {
                    int dw = this.d.get(w);
                    this.d.compareAndSet(w, -1, this.phase + 1);
                    if (dw == -1) {
                        this.phaseQueue.addOrCreate(this.phase + 1, w);
                        this.count.incrementAndGet();
                        dw = this.phase + 1;
                    }
                    if (dw == this.phase + 1) {
                        this.sigma.addAndGet(w, this.sigma.get(v));
                        this.successors.addOrCreate(v, w);
                    }
                    return true;
                });
            });
            ParallelUtil.awaitTermination(this.futures);
            ++this.phase;
        }
        Arrays.fill(this.delta, 0.0);
        while (--this.phase > 0 && this.running()) {
            this.futures.clear();
            this.phaseQueue.forEach(this.futures, this.phase, w -> {
                double[] dsw = new double[]{0.0};
                double sw = this.sigma.get(w);
                this.successors.forEach(w, v -> {
                    dsw[0] = dsw[0] + sw / (double)this.sigma.get(v) * (1.0 + this.delta[v]);
                });
                this.delta[w] = dsw[0];
                this.centrality.add(w, dsw[0]);
            });
            ParallelUtil.awaitTermination(this.futures);
        }
        return true;
    }

    public AtomicDoubleArray getCentrality() {
        return this.centrality;
    }

    public void forEach(BetweennessCentrality.ResultConsumer consumer) {
        for (int i = this.nodeCount - 1; i >= 0; --i) {
            if (consumer.consume(this.graph.toOriginalNodeId(i), this.centrality.get(i))) continue;
            return;
        }
    }

    public Stream<BetweennessCentrality.Result> resultStream() {
        return IntStream.range(0, this.nodeCount).mapToObj(nodeId -> new BetweennessCentrality.Result(this.graph.toOriginalNodeId(nodeId), this.centrality.get(nodeId)));
    }

    @Override
    public BetweennessCentralitySuccessorBrandes me() {
        return this;
    }

    @Override
    public BetweennessCentralitySuccessorBrandes release() {
        this.graph = null;
        this.centrality = null;
        this.executorService = null;
        this.sigma = null;
        this.d = null;
        this.delta = null;
        this.count = null;
        this.successors = null;
        this.phaseQueue = null;
        this.futures = null;
        return this;
    }
}

