/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import com.carrotsearch.hppc.IntScatterSet;
import com.carrotsearch.hppc.IntSet;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.utils.traverse.ParallelLocalQueueBFS;
import org.neo4j.graphalgo.impl.Algorithm;
import org.neo4j.graphdb.Direction;

public class ForwardBackwardScc
extends Algorithm<ForwardBackwardScc> {
    private ParallelLocalQueueBFS traverse;
    private IntSet scc = new IntScatterSet();
    private Graph graph;

    public ForwardBackwardScc(Graph graph, ExecutorService executorService, int concurrency) {
        this.graph = graph;
        this.traverse = new ParallelLocalQueueBFS(graph, executorService, concurrency);
    }

    public ForwardBackwardScc compute(int startNodeId) {
        this.scc.clear();
        IntScatterSet descendant = new IntScatterSet();
        this.traverse.bfs(startNodeId, Direction.OUTGOING, node -> this.running(), descendant::add).awaitTermination();
        this.getProgressLogger().logProgress(0.5);
        this.traverse.reset().bfs(startNodeId, Direction.INCOMING, node -> descendant.contains(node) && this.running(), this.scc::add).awaitTermination();
        this.getProgressLogger().logDone();
        this.scc.retainAll(descendant);
        return this;
    }

    public IntSet getScc() {
        return this.scc;
    }

    public Stream<Result> resultStream() {
        return StreamSupport.stream(this.scc.spliterator(), false).map(node -> new Result(this.graph.toOriginalNodeId(node.value)));
    }

    @Override
    public ForwardBackwardScc me() {
        return this;
    }

    @Override
    public ForwardBackwardScc release() {
        this.graph = null;
        this.traverse = null;
        this.scc = null;
        return this;
    }

    public class Result {
        public final long nodeId;

        public Result(long nodeId) {
            this.nodeId = nodeId;
        }
    }
}

