/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.dss.DisjointSetStruct;
import org.neo4j.graphalgo.impl.Algorithm;
import org.neo4j.graphdb.Direction;

public class GraphUnionFind
extends Algorithm<GraphUnionFind> {
    private Graph graph;
    private DisjointSetStruct dss;
    private final int nodeCount;

    public GraphUnionFind(Graph graph) {
        this.graph = graph;
        this.nodeCount = Math.toIntExact(graph.nodeCount());
        this.dss = new DisjointSetStruct(this.nodeCount);
    }

    public DisjointSetStruct compute() {
        this.dss.reset();
        ProgressLogger progressLogger = this.getProgressLogger();
        this.graph.forEachNode(node -> {
            if (!this.running()) {
                return false;
            }
            this.graph.forEachRelationship(node, Direction.OUTGOING, (source, target, id) -> {
                this.dss.union(source, target);
                return true;
            });
            progressLogger.logProgress((double)node / (double)(this.nodeCount - 1));
            return true;
        });
        return this.dss;
    }

    public DisjointSetStruct compute(double threshold) {
        this.dss.reset();
        ProgressLogger progressLogger = this.getProgressLogger();
        this.graph.forEachNode(node -> {
            if (!this.running()) {
                return false;
            }
            this.graph.forEachRelationship(node, Direction.OUTGOING, (source, target, id, weight) -> {
                if (weight >= threshold) {
                    this.dss.union(source, target);
                }
                return true;
            });
            progressLogger.logProgress((double)node / (double)(this.nodeCount - 1));
            return true;
        });
        return this.dss;
    }

    @Override
    public GraphUnionFind me() {
        return this;
    }

    @Override
    public GraphUnionFind release() {
        this.graph = null;
        this.dss = null;
        return this;
    }
}

