/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import com.carrotsearch.hppc.AbstractIterator;
import java.util.Spliterators;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphalgo.api.HugeGraph;
import org.neo4j.graphalgo.api.HugeIdMapping;
import org.neo4j.graphalgo.api.HugeRelationshipIterator;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.impl.AllShortestPaths;
import org.neo4j.graphalgo.impl.MSBFSASPAlgorithm;
import org.neo4j.graphalgo.impl.msbfs.HugeMultiSourceBFS;
import org.neo4j.graphdb.Direction;

public class HugeMSBFSAllShortestPaths
extends MSBFSASPAlgorithm<HugeMSBFSAllShortestPaths> {
    private HugeGraph graph;
    private BlockingQueue<AllShortestPaths.Result> resultQueue;
    private final AllocationTracker tracker;
    private final int concurrency;
    private final ExecutorService executorService;
    private final long nodeCount;

    public HugeMSBFSAllShortestPaths(HugeGraph graph, AllocationTracker tracker, int concurrency, ExecutorService executorService) {
        this.graph = graph;
        this.nodeCount = graph.nodeCount();
        this.tracker = tracker;
        this.concurrency = concurrency;
        this.executorService = executorService;
        this.resultQueue = new LinkedBlockingQueue<AllShortestPaths.Result>();
    }

    @Override
    public Stream<AllShortestPaths.Result> resultStream() {
        this.executorService.submit(new ShortestPathTask(this.concurrency, this.executorService));
        AbstractIterator<AllShortestPaths.Result> iterator = new AbstractIterator<AllShortestPaths.Result>(){

            @Override
            protected AllShortestPaths.Result fetch() {
                try {
                    AllShortestPaths.Result result = (AllShortestPaths.Result)HugeMSBFSAllShortestPaths.this.resultQueue.take();
                    if (result.sourceNodeId == -1L) {
                        return (AllShortestPaths.Result)this.done();
                    }
                    return result;
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false);
    }

    @Override
    public HugeMSBFSAllShortestPaths me() {
        return this;
    }

    @Override
    public HugeMSBFSAllShortestPaths release() {
        this.graph = null;
        this.resultQueue = null;
        return this;
    }

    private class ShortestPathTask
    implements Runnable {
        private final int concurrency;
        private final ExecutorService executorService;

        private ShortestPathTask(int concurrency, ExecutorService executorService) {
            this.concurrency = concurrency;
            this.executorService = executorService;
        }

        @Override
        public void run() {
            ProgressLogger progressLogger = HugeMSBFSAllShortestPaths.this.getProgressLogger();
            double maxNodeId = HugeMSBFSAllShortestPaths.this.nodeCount - 1L;
            new HugeMultiSourceBFS((HugeIdMapping)HugeMSBFSAllShortestPaths.this.graph, (HugeRelationshipIterator)HugeMSBFSAllShortestPaths.this.graph, Direction.OUTGOING, (target, distance, sources) -> {
                while (sources.hasNext()) {
                    long source = sources.next();
                    AllShortestPaths.Result result = new AllShortestPaths.Result(HugeMSBFSAllShortestPaths.this.graph.toOriginalNodeId(source), HugeMSBFSAllShortestPaths.this.graph.toOriginalNodeId(target), distance);
                    try {
                        HugeMSBFSAllShortestPaths.this.resultQueue.put(result);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                progressLogger.logProgress((double)target, maxNodeId);
            }, HugeMSBFSAllShortestPaths.this.tracker, new long[0]).run(this.concurrency, this.executorService);
            HugeMSBFSAllShortestPaths.this.resultQueue.add(new AllShortestPaths.Result(-1L, -1L, -1.0));
        }
    }
}

