/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import java.util.concurrent.ExecutorService;
import java.util.function.LongToIntFunction;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.graphalgo.api.HugeGraph;
import org.neo4j.graphalgo.api.HugeIdMapping;
import org.neo4j.graphalgo.api.HugeRelationshipIterator;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.AtomicIntArray;
import org.neo4j.graphalgo.core.write.Exporter;
import org.neo4j.graphalgo.impl.MSBFSCCAlgorithm;
import org.neo4j.graphalgo.impl.MSClosenessCentrality;
import org.neo4j.graphalgo.impl.msbfs.HugeBfsConsumer;
import org.neo4j.graphalgo.impl.msbfs.HugeMultiSourceBFS;
import org.neo4j.graphdb.Direction;

public class HugeMSClosenessCentrality
extends MSBFSCCAlgorithm<HugeMSClosenessCentrality> {
    private HugeGraph graph;
    private AtomicIntArray farness;
    private final int concurrency;
    private final ExecutorService executorService;
    private final long nodeCount;
    private final AllocationTracker tracker;

    public HugeMSClosenessCentrality(HugeGraph graph, AllocationTracker tracker, int concurrency, ExecutorService executorService) {
        this.graph = graph;
        this.nodeCount = graph.nodeCount();
        this.concurrency = concurrency;
        this.executorService = executorService;
        this.tracker = tracker;
        this.farness = AtomicIntArray.newArray(this.nodeCount, this.tracker);
    }

    @Override
    public HugeMSClosenessCentrality compute() {
        ProgressLogger progressLogger = this.getProgressLogger();
        HugeBfsConsumer consumer = (nodeId, depth, sourceNodeIds) -> {
            int len = sourceNodeIds.size();
            this.farness.add(nodeId, len * depth);
            progressLogger.logProgress((double)nodeId / (double)(this.nodeCount - 1L));
        };
        new HugeMultiSourceBFS((HugeIdMapping)this.graph, (HugeRelationshipIterator)this.graph, Direction.OUTGOING, consumer, this.tracker, new long[0]).run(this.concurrency, this.executorService);
        return this;
    }

    @Override
    public void export(String propertyName, Exporter exporter) {
        double k = this.nodeCount - 1L;
        exporter.write(propertyName, this.farness, (data, nodeId) -> HugeMSClosenessCentrality.centrality(data.get(nodeId), k));
    }

    @Override
    public LongToIntFunction farness() {
        return this.farness::get;
    }

    @Override
    public Stream<MSClosenessCentrality.Result> resultStream() {
        double k = this.nodeCount - 1L;
        return LongStream.range(0L, this.nodeCount).mapToObj(nodeId -> new MSClosenessCentrality.Result(this.graph.toOriginalNodeId(nodeId), HugeMSClosenessCentrality.centrality(this.farness.get(nodeId), k)));
    }

    @Override
    public HugeMSClosenessCentrality me() {
        return this;
    }

    @Override
    public HugeMSClosenessCentrality release() {
        this.graph = null;
        this.farness = null;
        return this;
    }
}

