/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.LongArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphalgo.api.HugeDegrees;
import org.neo4j.graphalgo.api.HugeIdMapping;
import org.neo4j.graphalgo.api.HugeNodeIterator;
import org.neo4j.graphalgo.api.HugeRelationshipConsumer;
import org.neo4j.graphalgo.api.HugeRelationshipIterator;
import org.neo4j.graphalgo.core.utils.ArrayUtil;
import org.neo4j.graphalgo.core.utils.ParallelUtil;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.MemoryUsage;
import org.neo4j.graphalgo.core.write.DoubleArrayTranslator;
import org.neo4j.graphalgo.core.write.Exporter;
import org.neo4j.graphalgo.core.write.PropertyTranslator;
import org.neo4j.graphalgo.impl.Algorithm;
import org.neo4j.graphalgo.impl.PageRankAlgorithm;
import org.neo4j.graphalgo.impl.PageRankResult;
import org.neo4j.graphdb.Direction;
import org.neo4j.logging.Log;

public class HugePageRank
extends Algorithm<HugePageRank>
implements PageRankAlgorithm {
    private final ExecutorService executor;
    private final int concurrency;
    private final int batchSize;
    private final AllocationTracker tracker;
    private final HugeIdMapping idMapping;
    private final HugeNodeIterator nodeIterator;
    private final HugeRelationshipIterator relationshipIterator;
    private final HugeDegrees degrees;
    private final double dampingFactor;
    private Log log;
    private ComputeSteps computeSteps;

    HugePageRank(AllocationTracker tracker, HugeIdMapping idMapping, HugeNodeIterator nodeIterator, HugeRelationshipIterator relationshipIterator, HugeDegrees degrees, double dampingFactor) {
        this(null, -1, 10000, tracker, idMapping, nodeIterator, relationshipIterator, degrees, dampingFactor);
    }

    HugePageRank(ExecutorService executor, int concurrency, int batchSize, AllocationTracker tracker, HugeIdMapping idMapping, HugeNodeIterator nodeIterator, HugeRelationshipIterator relationshipIterator, HugeDegrees degrees, double dampingFactor) {
        this.executor = executor;
        this.concurrency = concurrency;
        this.batchSize = batchSize;
        this.tracker = tracker;
        this.idMapping = idMapping;
        this.nodeIterator = nodeIterator;
        this.relationshipIterator = relationshipIterator;
        this.degrees = degrees;
        this.dampingFactor = dampingFactor;
    }

    @Override
    public HugePageRank compute(int iterations) {
        assert (iterations >= 1);
        this.initializeSteps();
        this.computeSteps.run(iterations);
        return this;
    }

    @Override
    public PageRankResult result() {
        return this.computeSteps.getPageRank();
    }

    @Override
    public Algorithm<?> algorithm() {
        return this;
    }

    @Override
    public HugePageRank withLog(Log log) {
        super.withLog(log);
        this.log = log;
        return this;
    }

    private void initializeSteps() {
        if (this.computeSteps != null) {
            return;
        }
        List<Partition> partitions = this.partitionGraph(this.adjustBatchSize(this.batchSize), this.nodeIterator, this.degrees);
        ExecutorService executor = ParallelUtil.canRunInParallel(this.executor) ? this.executor : null;
        this.computeSteps = this.createComputeSteps(this.concurrency, this.idMapping.nodeCount(), this.dampingFactor, this.relationshipIterator, this.degrees, partitions, executor);
    }

    private int adjustBatchSize(int batchSize) {
        return (batchSize <<= 3) > 0 ? batchSize : Integer.MAX_VALUE;
    }

    private List<Partition> partitionGraph(int batchSize, HugeNodeIterator nodeIterator, HugeDegrees degrees) {
        PrimitiveLongIterator nodes = nodeIterator.hugeNodeIterator();
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        long start = 0L;
        while (nodes.hasNext()) {
            Partition partition = new Partition(nodes, degrees, start, batchSize);
            partitions.add(partition);
            start += (long)partition.nodeCount;
        }
        return partitions;
    }

    private ComputeSteps createComputeSteps(int concurrency, long nodeCount, double dampingFactor, HugeRelationshipIterator relationshipIterator, HugeDegrees degrees, List<Partition> partitions, ExecutorService pool) {
        concurrency = HugePageRank.findIdealConcurrency(nodeCount, partitions, concurrency, this.log);
        int expectedParallelism = Math.min(concurrency, partitions.size());
        ArrayList<ComputeStep> computeSteps = new ArrayList<ComputeStep>(expectedParallelism);
        LongArrayList starts = new LongArrayList(expectedParallelism);
        IntArrayList lengths = new IntArrayList(expectedParallelism);
        int partitionsPerThread = ParallelUtil.threadSize(concurrency + 1, partitions.size());
        Iterator<Partition> parts = partitions.iterator();
        while (parts.hasNext()) {
            Partition partition = parts.next();
            int partitionCount = partition.nodeCount;
            long start = partition.startNode;
            for (int i = 1; parts.hasNext() && i < partitionsPerThread && partition.fits(partitionCount); ++i) {
                partition = parts.next();
                partitionCount += partition.nodeCount;
            }
            starts.add(start);
            lengths.add(partitionCount);
            computeSteps.add(new ComputeStep(dampingFactor, relationshipIterator, degrees, this.tracker, partitionCount, start));
        }
        long[] startArray = starts.toArray();
        int[] lengthArray = lengths.toArray();
        for (ComputeStep computeStep : computeSteps) {
            computeStep.setStarts(startArray, lengthArray);
        }
        return new ComputeSteps(this.tracker, computeSteps, concurrency, pool);
    }

    private static int findIdealConcurrency(long nodeCount, List<Partition> partitions, int concurrency, Log log) {
        int maxConcurrency;
        if (concurrency <= 0) {
            concurrency = partitions.size();
        }
        if (log != null && log.isDebugEnabled()) {
            log.debug("PageRank: nodes=%d, concurrency=%d, available memory=%s, estimated memory usage: %s", new Object[]{nodeCount, concurrency, AllocationTracker.humanReadable(HugePageRank.availableMemory()), AllocationTracker.humanReadable(HugePageRank.memoryUsageFor(concurrency, partitions))});
        }
        if (concurrency > (maxConcurrency = HugePageRank.maxConcurrencyByMemory(nodeCount, concurrency, HugePageRank.availableMemory(), partitions))) {
            if (log != null) {
                long required = HugePageRank.memoryUsageFor(concurrency, partitions);
                long newRequired = HugePageRank.memoryUsageFor(maxConcurrency, partitions);
                long available = HugePageRank.availableMemory();
                log.warn("Requested concurrency of %d would require %s Heap but only %s are available, PageRank will be throttled to a concurrency of %d to use only %s Heap.", new Object[]{concurrency, AllocationTracker.humanReadable(required), AllocationTracker.humanReadable(available), maxConcurrency, AllocationTracker.humanReadable(newRequired)});
            }
            concurrency = maxConcurrency;
        }
        return concurrency;
    }

    private static int maxConcurrencyByMemory(long nodeCount, int concurrency, long availableBytes, List<Partition> partitions) {
        int newConcurrency = concurrency;
        long memoryUsage = HugePageRank.memoryUsageFor(newConcurrency, partitions);
        while (memoryUsage > availableBytes) {
            long perThread = HugePageRank.estimateMemoryUsagePerThread(nodeCount, concurrency);
            long overflow = memoryUsage - availableBytes;
            memoryUsage = HugePageRank.memoryUsageFor(newConcurrency -= (int)Math.ceil((double)overflow / (double)perThread), partitions);
        }
        return newConcurrency;
    }

    private static long availableMemory() {
        Runtime rt = Runtime.getRuntime();
        long max = rt.maxMemory();
        long total = rt.totalMemory();
        long free = rt.freeMemory();
        return max - total + free;
    }

    private static long estimateMemoryUsagePerThread(long nodeCount, int concurrency) {
        int nodesPerThread = (int)Math.ceil((double)nodeCount / (double)concurrency);
        long partitions = MemoryUsage.sizeOfIntArray(nodesPerThread) * (long)concurrency;
        return MemoryUsage.shallowSizeOfInstance(ComputeStep.class) + partitions;
    }

    private static long memoryUsageFor(int concurrency, List<Partition> partitions) {
        long perThreadUsage = 0L;
        long sharedUsage = 0L;
        int stepSize = 0;
        int partitionsPerThread = ParallelUtil.threadSize(concurrency + 1, partitions.size());
        Iterator<Partition> parts = partitions.iterator();
        while (parts.hasNext()) {
            Partition partition = parts.next();
            int partitionCount = partition.nodeCount;
            for (int i = 1; parts.hasNext() && i < partitionsPerThread && partition.fits(partitionCount); ++i) {
                partition = parts.next();
                partitionCount += partition.nodeCount;
            }
            ++stepSize;
            sharedUsage += MemoryUsage.sizeOfDoubleArray(partitionCount) << 1;
            perThreadUsage += MemoryUsage.sizeOfIntArray(partitionCount);
        }
        perThreadUsage *= (long)stepSize;
        perThreadUsage += MemoryUsage.shallowSizeOfInstance(ComputeStep.class);
        sharedUsage += MemoryUsage.shallowSizeOfInstance(ComputeSteps.class);
        return (sharedUsage += MemoryUsage.sizeOfLongArray(stepSize) << 1) + (perThreadUsage += MemoryUsage.sizeOfObjectArray(stepSize));
    }

    @Override
    public HugePageRank me() {
        return this;
    }

    @Override
    public HugePageRank release() {
        this.computeSteps.release();
        return this;
    }

    private static final class DoubleArrayResult
    implements PageRankResult {
        private final double[] result;

        private DoubleArrayResult(double[] result) {
            this.result = result;
        }

        @Override
        public void export(String propertyName, Exporter exporter) {
            exporter.write(propertyName, this.result, DoubleArrayTranslator.INSTANCE);
        }

        @Override
        public final double score(long nodeId) {
            return this.result[(int)nodeId];
        }

        @Override
        public double score(int nodeId) {
            return this.result[nodeId];
        }
    }

    private static final class PartitionedDoubleArrayResult
    implements PageRankResult,
    PropertyTranslator.OfDouble<double[][]> {
        private final double[][] partitions;
        private final long[] starts;

        private PartitionedDoubleArrayResult(double[][] partitions, long[] starts) {
            this.partitions = partitions;
            this.starts = starts;
        }

        @Override
        public void export(String propertyName, Exporter exporter) {
            exporter.write(propertyName, this.partitions, this);
        }

        @Override
        public double toDouble(double[][] data, long nodeId) {
            int idx = ArrayUtil.binaryLookup(nodeId, this.starts);
            return data[idx][(int)(nodeId - this.starts[idx])];
        }

        @Override
        public double score(long nodeId) {
            return this.toDouble(this.partitions, nodeId);
        }

        @Override
        public double score(int nodeId) {
            return this.score((long)nodeId);
        }
    }

    private static final class ComputeStep
    implements Runnable,
    HugeRelationshipConsumer {
        private static final int S_INIT = 0;
        private static final int S_CALC = 1;
        private static final int S_SYNC = 2;
        private int state;
        private long[] starts;
        private int[] lengths;
        private final HugeRelationshipIterator relationshipIterator;
        private final HugeDegrees degrees;
        private final AllocationTracker tracker;
        private final double alpha;
        private final double dampingFactor;
        private double[] pageRank;
        private double[] deltas;
        private int[][] nextScores;
        private int[][] prevScores;
        private final long startNode;
        private final long endNode;
        private final int partitionSize;
        private int srcRankDelta = 0;

        ComputeStep(double dampingFactor, HugeRelationshipIterator relationshipIterator, HugeDegrees degrees, AllocationTracker tracker, int partitionSize, long startNode) {
            this.dampingFactor = dampingFactor;
            this.alpha = 1.0 - dampingFactor;
            this.relationshipIterator = relationshipIterator.concurrentCopy();
            this.degrees = degrees;
            this.tracker = tracker;
            this.partitionSize = partitionSize;
            this.startNode = startNode;
            this.endNode = startNode + (long)partitionSize;
            this.state = 0;
        }

        void setStarts(long[] starts, int[] lengths) {
            this.starts = starts;
            this.lengths = lengths;
        }

        @Override
        public void run() {
            if (this.state == 1) {
                this.singleIteration();
                this.state = 2;
            } else if (this.state == 2) {
                this.combineScores();
                this.state = 1;
            } else if (this.state == 0) {
                this.initialize();
                this.state = 1;
            }
        }

        private void initialize() {
            this.nextScores = new int[this.starts.length][];
            Arrays.setAll(this.nextScores, i -> {
                int size = this.lengths[i];
                this.tracker.add(MemoryUsage.sizeOfIntArray(size));
                return new int[size];
            });
            this.tracker.add(MemoryUsage.sizeOfDoubleArray(this.partitionSize) << 1);
            double[] partitionRank = new double[this.partitionSize];
            Arrays.fill(partitionRank, this.alpha);
            this.pageRank = partitionRank;
            this.deltas = Arrays.copyOf(partitionRank, this.partitionSize);
        }

        private void singleIteration() {
            long startNode = this.startNode;
            long endNode = this.endNode;
            HugeRelationshipIterator rels = this.relationshipIterator;
            for (long nodeId = startNode; nodeId < endNode; ++nodeId) {
                int degree;
                double delta = this.deltas[(int)(nodeId - startNode)];
                if (!(delta > 0.0) || (degree = this.degrees.degree(nodeId, Direction.OUTGOING)) <= 0) continue;
                this.srcRankDelta = (int)(100000.0 * (delta / (double)degree));
                rels.forEachRelationship(nodeId, Direction.OUTGOING, this);
            }
        }

        @Override
        public boolean accept(long sourceNodeId, long targetNodeId) {
            if (this.srcRankDelta != 0) {
                int idx = ArrayUtil.binaryLookup(targetNodeId, this.starts);
                int[] nArray = this.nextScores[idx];
                int n = (int)(targetNodeId - this.starts[idx]);
                nArray[n] = nArray[n] + this.srcRankDelta;
            }
            return true;
        }

        void prepareNextIteration(int[][] prevScores) {
            this.prevScores = prevScores;
        }

        private void combineScores() {
            assert (this.prevScores != null);
            assert (this.prevScores.length >= 1);
            int scoreDim = this.prevScores.length;
            int[][] prevScores = this.prevScores;
            int length = prevScores[0].length;
            for (int i = 0; i < length; ++i) {
                int sum = 0;
                for (int j = 0; j < scoreDim; ++j) {
                    int[] scores = prevScores[j];
                    sum += scores[i];
                    scores[i] = 0;
                }
                double delta = this.dampingFactor * ((double)sum / 100000.0);
                int n = i;
                this.pageRank[n] = this.pageRank[n] + delta;
                this.deltas[i] = delta;
            }
        }
    }

    private final class ComputeSteps {
        private List<ComputeStep> steps;
        private final ExecutorService pool;
        private int[][][] scores;
        private final int concurrency;

        private ComputeSteps(AllocationTracker tracker, List<ComputeStep> steps, int concurrency, ExecutorService pool) {
            this.concurrency = concurrency;
            assert (!steps.isEmpty());
            this.steps = steps;
            this.pool = pool;
            int stepSize = steps.size();
            this.scores = new int[stepSize][stepSize][];
            if (AllocationTracker.isTracking(tracker)) {
                tracker.add((long)(stepSize + 1) * MemoryUsage.sizeOfObjectArray(stepSize));
            }
        }

        PageRankResult getPageRank() {
            ComputeStep firstStep = this.steps.get(0);
            if (this.steps.size() > 1) {
                double[][] results = new double[this.steps.size()][];
                int i = 0;
                for (ComputeStep step : this.steps) {
                    results[i++] = step.pageRank;
                }
                return new PartitionedDoubleArrayResult(results, firstStep.starts);
            }
            return new DoubleArrayResult(firstStep.pageRank);
        }

        private void run(int iterations) {
            int operations = (iterations << 1) + 1;
            int op = 0;
            ParallelUtil.runWithConcurrency(this.concurrency, this.steps, this.pool);
            HugePageRank.this.getProgressLogger().logProgress(++op, operations, HugePageRank.this.tracker);
            for (int i = 0; i < iterations && HugePageRank.this.running(); ++i) {
                ParallelUtil.runWithConcurrency(this.concurrency, this.steps, this.pool);
                HugePageRank.this.getProgressLogger().logProgress(++op, operations, HugePageRank.this.tracker);
                this.synchronizeScores();
                ParallelUtil.runWithConcurrency(this.concurrency, this.steps, this.pool);
                HugePageRank.this.getProgressLogger().logProgress(++op, operations, HugePageRank.this.tracker);
            }
        }

        private void synchronizeScores() {
            int stepSize = this.steps.size();
            int[][][] scores = this.scores;
            for (int i = 0; i < stepSize; ++i) {
                this.synchronizeScores(this.steps.get(i), i, scores);
            }
        }

        private void synchronizeScores(ComputeStep step, int idx, int[][][] scores) {
            step.prepareNextIteration(scores[idx]);
            for (int[] scores[j][idx] : step.nextScores) {
            }
        }

        private void release() {
            if (AllocationTracker.isTracking(HugePageRank.this.tracker)) {
                HugePageRank.this.tracker.remove((long)(this.scores.length + 1) * MemoryUsage.sizeOfObjectArray(this.scores.length));
            }
            this.steps.clear();
            this.steps = null;
            this.scores = null;
        }
    }

    private static final class Partition {
        private static final int MAX_NODE_COUNT = 0x3FFFFFEF;
        private final long startNode;
        private final int nodeCount;

        Partition(PrimitiveLongIterator nodes, HugeDegrees degrees, long startNode, long batchSize) {
            long nodeId;
            assert (batchSize > 0L);
            int nodeCount = 0;
            for (long partitionSize = 0L; nodes.hasNext() && partitionSize < batchSize && nodeCount < 0x3FFFFFEF; ++nodeCount, partitionSize += (long)degrees.degree(nodeId, Direction.OUTGOING)) {
                nodeId = nodes.next();
            }
            this.startNode = startNode;
            this.nodeCount = nodeCount;
        }

        private boolean fits(int otherPartitionsCount) {
            return 0x3FFFFFEF - otherPartitionsCount >= this.nodeCount;
        }
    }
}

