/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntDoubleHashMap;
import com.carrotsearch.hppc.IntDoubleScatterMap;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.cursors.IntDoubleCursor;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import org.neo4j.collection.primitive.PrimitiveIntIterable;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.graphalgo.api.RelationshipConsumer;
import org.neo4j.graphalgo.core.heavyweight.HeavyGraph;
import org.neo4j.graphalgo.core.utils.ParallelUtil;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.impl.Algorithm;
import org.neo4j.graphdb.Direction;

public final class LabelPropagation
extends Algorithm<LabelPropagation> {
    private static final int[] EMPTY_INTS = new int[0];
    private HeavyGraph graph;
    private final int batchSize;
    private final int concurrency;
    private final ExecutorService executor;
    private final int nodeCount;
    private int[] labels;
    private long ranIterations;
    private boolean didConverge;

    public LabelPropagation(HeavyGraph graph, int batchSize, int concurrency, ExecutorService executor) {
        this.graph = graph;
        this.nodeCount = Math.toIntExact(graph.nodeCount());
        this.batchSize = batchSize;
        this.concurrency = concurrency;
        this.executor = executor;
    }

    public LabelPropagation compute(Direction direction, long maxIterations) {
        return this.compute(direction, maxIterations, true);
    }

    public LabelPropagation compute(Direction direction, long maxIterations, boolean randomizeOrder) {
        if (maxIterations <= 0L) {
            throw new IllegalArgumentException("Must iterate at least 1 time");
        }
        if (this.labels == null || this.labels.length != this.nodeCount) {
            this.labels = new int[this.nodeCount];
        }
        this.ranIterations = 0L;
        this.didConverge = false;
        List<Runnable> computeSteps = ParallelUtil.readParallel(this.concurrency, this.batchSize, this.graph, (offset, nodes) -> new InitStep(this.graph, this.labels, direction, randomizeOrder, this.getProgressLogger(), nodes), this.executor);
        int l = computeSteps.size();
        for (int i = 0; i < l; ++i) {
            computeSteps.set(i, ((InitStep)computeSteps.get(i)).computeStep());
        }
        for (long i = 0L; i < maxIterations; ++i) {
            ParallelUtil.runWithConcurrency(this.concurrency, computeSteps, this.executor);
        }
        long maxIteration = 0L;
        boolean converged = true;
        for (Runnable computeStep : computeSteps) {
            ComputeStep step = (ComputeStep)computeStep;
            if (step.iteration > maxIteration) {
                maxIteration = step.iteration;
            }
            converged = converged && !step.didChange;
            step.release();
        }
        this.ranIterations = maxIteration;
        this.didConverge = converged;
        return this;
    }

    public long ranIterations() {
        return this.ranIterations;
    }

    public boolean didConverge() {
        return this.didConverge;
    }

    public int[] labels() {
        return this.labels;
    }

    public IntObjectMap<IntArrayList> groupByPartition() {
        if (this.labels == null) {
            return null;
        }
        IntObjectHashMap<IntArrayList> cluster = new IntObjectHashMap<IntArrayList>();
        int l = this.labels.length;
        for (int node = 0; node < l; ++node) {
            int key = this.labels[node];
            IntArrayList ids = (IntArrayList)cluster.get(key);
            if (ids == null) {
                ids = new IntArrayList();
                cluster.put(key, ids);
            }
            ids.add(node);
        }
        return cluster;
    }

    @Override
    public LabelPropagation me() {
        return this;
    }

    @Override
    public LabelPropagation release() {
        this.graph = null;
        return this;
    }

    private static final class RandomlySwitchingIterator
    implements PrimitiveIntIterator {
        private final PrimitiveIntIterator delegate;
        private final Random random;
        private boolean hasSkipped;
        private int skipped;

        private RandomlySwitchingIterator(PrimitiveIntIterator delegate, Random random) {
            this.delegate = delegate;
            this.random = random;
        }

        public boolean hasNext() {
            return this.hasSkipped || this.delegate.hasNext();
        }

        public int next() {
            if (this.hasSkipped) {
                int elem = this.skipped;
                this.hasSkipped = false;
                return elem;
            }
            int next = this.delegate.next();
            if (this.delegate.hasNext() && this.random.nextBoolean()) {
                this.skipped = next;
                this.hasSkipped = true;
                return this.delegate.next();
            }
            return next;
        }
    }

    private static final class RandomlySwitchingIterable
    implements PrimitiveIntIterable {
        private final PrimitiveIntIterable delegate;
        private final Random random;

        static PrimitiveIntIterable of(boolean randomize, PrimitiveIntIterable delegate) {
            return randomize ? new RandomlySwitchingIterable(delegate, ThreadLocalRandom.current()) : delegate;
        }

        private RandomlySwitchingIterable(PrimitiveIntIterable delegate, Random random) {
            this.delegate = delegate;
            this.random = random;
        }

        public PrimitiveIntIterator iterator() {
            return new RandomlySwitchingIterator(this.delegate.iterator(), this.random);
        }
    }

    private static final class ComputeStep
    implements Runnable,
    RelationshipConsumer {
        private final HeavyGraph graph;
        private final int[] existingLabels;
        private final Direction direction;
        private final ProgressLogger progressLogger;
        private final PrimitiveIntIterable nodes;
        private final int maxNode;
        private final IntDoubleHashMap votes;
        private boolean didChange = true;
        private long iteration = 0L;

        private ComputeStep(HeavyGraph graph, int[] existingLabels, Direction direction, boolean randomizeOrder, ProgressLogger progressLogger, PrimitiveIntIterable nodes) {
            this.graph = graph;
            this.existingLabels = existingLabels;
            this.direction = direction;
            this.progressLogger = progressLogger;
            this.nodes = RandomlySwitchingIterable.of(randomizeOrder, nodes);
            this.maxNode = (int)(graph.nodeCount() - 1L);
            this.votes = new IntDoubleScatterMap();
        }

        @Override
        public void run() {
            if (this.didChange) {
                ++this.iteration;
                PrimitiveIntIterator iterator = this.nodes.iterator();
                boolean didChange = false;
                while (iterator.hasNext()) {
                    didChange = this.compute(iterator.next(), didChange);
                }
                this.didChange = didChange;
                if (!didChange) {
                    this.release();
                }
            }
        }

        private boolean compute(int nodeId, boolean didChange) {
            int partition;
            this.votes.clear();
            int previous = partition = this.existingLabels[nodeId];
            this.graph.forEachRelationship(nodeId, this.direction, this);
            double weight = Double.NEGATIVE_INFINITY;
            for (IntDoubleCursor vote : this.votes) {
                if (!(weight < vote.value)) continue;
                weight = vote.value;
                partition = vote.key;
            }
            this.progressLogger.logProgress((double)nodeId, this.maxNode);
            if (partition != previous) {
                this.existingLabels[nodeId] = partition;
                return true;
            }
            return didChange;
        }

        @Override
        public boolean accept(int sourceNodeId, int targetNodeId, long relationId) {
            int partition = this.existingLabels[targetNodeId];
            double weight = this.graph.weightOf(sourceNodeId, targetNodeId) * this.graph.weightOf(targetNodeId);
            this.votes.addTo(partition, weight);
            return true;
        }

        private void release() {
            if (this.votes.keys != null) {
                this.votes.keys = EMPTY_INTS;
                this.votes.clear();
                this.votes.keys = null;
                this.votes.values = null;
            }
        }
    }

    private static final class InitStep
    implements Runnable {
        private final HeavyGraph graph;
        private final int[] existingLabels;
        private final Direction direction;
        private final boolean randomizeOrder;
        private final ProgressLogger progressLogger;
        private final PrimitiveIntIterable nodes;

        private InitStep(HeavyGraph graph, int[] existingLabels, Direction direction, boolean randomizeOrder, ProgressLogger progressLogger, PrimitiveIntIterable nodes) {
            this.graph = graph;
            this.existingLabels = existingLabels;
            this.direction = direction;
            this.randomizeOrder = randomizeOrder;
            this.progressLogger = progressLogger;
            this.nodes = nodes;
        }

        @Override
        public void run() {
            this.initLabels();
        }

        private void initLabels() {
            for (int nodeId : this.nodes) {
                this.existingLabels[nodeId] = (int)this.graph.valueOf(nodeId, nodeId);
            }
        }

        private ComputeStep computeStep() {
            return new ComputeStep(this.graph, this.existingLabels, this.direction, this.randomizeOrder, this.progressLogger, this.nodes);
        }
    }
}

