/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import com.carrotsearch.hppc.AbstractIterator;
import java.util.Spliterators;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.api.RelationshipIterator;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.impl.AllShortestPaths;
import org.neo4j.graphalgo.impl.MSBFSASPAlgorithm;
import org.neo4j.graphalgo.impl.msbfs.MultiSourceBFS;
import org.neo4j.graphdb.Direction;

public class MSBFSAllShortestPaths
extends MSBFSASPAlgorithm<MSBFSAllShortestPaths> {
    private Graph graph;
    private BlockingQueue<AllShortestPaths.Result> resultQueue;
    private final int concurrency;
    private final ExecutorService executorService;
    private final int nodeCount;

    public MSBFSAllShortestPaths(Graph graph, int concurrency, ExecutorService executorService) {
        this.graph = graph;
        this.nodeCount = Math.toIntExact(graph.nodeCount());
        this.concurrency = concurrency;
        this.executorService = executorService;
        this.resultQueue = new LinkedBlockingQueue<AllShortestPaths.Result>();
    }

    @Override
    public Stream<AllShortestPaths.Result> resultStream() {
        this.executorService.submit(new ShortestPathTask(this.concurrency, this.executorService));
        AbstractIterator<AllShortestPaths.Result> iterator = new AbstractIterator<AllShortestPaths.Result>(){

            @Override
            protected AllShortestPaths.Result fetch() {
                try {
                    AllShortestPaths.Result result = (AllShortestPaths.Result)MSBFSAllShortestPaths.this.resultQueue.take();
                    if (result.sourceNodeId == -1L) {
                        return (AllShortestPaths.Result)this.done();
                    }
                    return result;
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false);
    }

    @Override
    public MSBFSAllShortestPaths me() {
        return this;
    }

    @Override
    public MSBFSAllShortestPaths release() {
        this.graph = null;
        this.resultQueue = null;
        return this;
    }

    private class ShortestPathTask
    implements Runnable {
        private final int concurrency;
        private final ExecutorService executorService;

        private ShortestPathTask(int concurrency, ExecutorService executorService) {
            this.concurrency = concurrency;
            this.executorService = executorService;
        }

        @Override
        public void run() {
            ProgressLogger progressLogger = MSBFSAllShortestPaths.this.getProgressLogger();
            new MultiSourceBFS((IdMapping)MSBFSAllShortestPaths.this.graph, (RelationshipIterator)MSBFSAllShortestPaths.this.graph, Direction.OUTGOING, (target, distance, sources) -> {
                while (sources.hasNext()) {
                    int source = sources.next();
                    AllShortestPaths.Result result = new AllShortestPaths.Result(MSBFSAllShortestPaths.this.graph.toOriginalNodeId(source), MSBFSAllShortestPaths.this.graph.toOriginalNodeId(target), distance);
                    try {
                        MSBFSAllShortestPaths.this.resultQueue.put(result);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                progressLogger.logProgress((double)target / (double)(MSBFSAllShortestPaths.this.nodeCount - 1));
            }, new int[0]).run(this.concurrency, this.executorService);
            MSBFSAllShortestPaths.this.resultQueue.add(new AllShortestPaths.Result(-1L, -1L, -1.0));
        }
    }
}

