/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.function.LongToIntFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.api.RelationshipIterator;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.write.Exporter;
import org.neo4j.graphalgo.impl.MSBFSCCAlgorithm;
import org.neo4j.graphalgo.impl.msbfs.BfsConsumer;
import org.neo4j.graphalgo.impl.msbfs.MultiSourceBFS;
import org.neo4j.graphdb.Direction;

public class MSClosenessCentrality
extends MSBFSCCAlgorithm<MSClosenessCentrality> {
    private Graph graph;
    private AtomicIntegerArray farness;
    private final int concurrency;
    private final ExecutorService executorService;
    private final int nodeCount;

    public MSClosenessCentrality(Graph graph, int concurrency, ExecutorService executorService) {
        this.graph = graph;
        this.nodeCount = Math.toIntExact(graph.nodeCount());
        this.concurrency = concurrency;
        this.executorService = executorService;
        this.farness = new AtomicIntegerArray(this.nodeCount);
    }

    @Override
    public MSClosenessCentrality compute() {
        ProgressLogger progressLogger = this.getProgressLogger();
        BfsConsumer consumer = (nodeId, depth, sourceNodeIds) -> {
            int len = sourceNodeIds.size();
            this.farness.addAndGet(nodeId, len * depth);
            progressLogger.logProgress((double)nodeId / (double)(this.nodeCount - 1));
        };
        new MultiSourceBFS((IdMapping)this.graph, (RelationshipIterator)this.graph, Direction.OUTGOING, consumer, new int[0]).run(this.concurrency, this.executorService);
        return this;
    }

    @Override
    public Stream<Result> resultStream() {
        double k = this.nodeCount - 1;
        return IntStream.range(0, this.nodeCount).mapToObj(nodeId -> new Result(this.graph.toOriginalNodeId(nodeId), MSClosenessCentrality.centrality(this.farness.get(nodeId), k)));
    }

    @Override
    public LongToIntFunction farness() {
        return i -> this.farness.get((int)i);
    }

    @Override
    public void export(String propertyName, Exporter exporter) {
        double k = this.nodeCount - 1;
        exporter.write(propertyName, this.farness, (data, nodeId) -> MSClosenessCentrality.centrality(data.get((int)nodeId), k));
    }

    @Override
    public MSClosenessCentrality me() {
        return this;
    }

    @Override
    public MSClosenessCentrality release() {
        this.graph = null;
        this.farness = null;
        return this;
    }

    public static final class Result {
        public final long nodeId;
        public final double centrality;

        public Result(long nodeId, double centrality) {
            this.nodeId = nodeId;
            this.centrality = centrality;
        }
    }
}

