/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import com.carrotsearch.hppc.IntIntScatterMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.api.RelationshipIterator;
import org.neo4j.graphalgo.core.utils.ParallelUtil;
import org.neo4j.graphalgo.impl.msbfs.BfsSources;
import org.neo4j.graphalgo.impl.msbfs.MultiSourceBFS;
import org.neo4j.graphdb.Direction;

public class MSColoring {
    private final Graph graph;
    private final ExecutorService executorService;
    private final AtomicIntegerArray colors;
    private final int concurrency;
    private int nodeCount;

    public MSColoring(Graph graph, ExecutorService executorService, int concurrency) {
        this.graph = graph;
        this.executorService = executorService;
        this.nodeCount = Math.toIntExact(graph.nodeCount());
        this.colors = new AtomicIntegerArray(this.nodeCount);
        this.concurrency = concurrency;
    }

    public AtomicIntegerArray getColors() {
        return this.colors;
    }

    public MSColoring compute() {
        this.reset();
        new MultiSourceBFS((IdMapping)this.graph, (RelationshipIterator)this.graph, Direction.OUTGOING, this::nodeAction, new int[0]).run(this.concurrency, this.executorService);
        return this;
    }

    public int getSetCount() {
        IntIntScatterMap map = new IntIntScatterMap();
        for (int i = this.nodeCount; i >= 0; --i) {
            int color = this.colors.get(i);
            map.addTo(color, 1);
        }
        return map.size();
    }

    public Stream<Result> resultStream() {
        return IntStream.range(0, this.nodeCount).mapToObj(i -> new Result(this.graph.toOriginalNodeId(i), this.colors.get(i)));
    }

    private void reset() {
        ParallelUtil.iterateParallel(this.executorService, this.nodeCount, Runtime.getRuntime().availableProcessors() * 2, offset -> this.colors.set(offset, offset));
    }

    private void nodeAction(int node, int depth, BfsSources bfsSources) {
        int bestColor = this.colors.get(node);
        while (bfsSources.hasNext()) {
            int sourceColor = this.colors.get(bfsSources.next());
            bestColor = Math.max(bestColor, sourceColor);
        }
        this.setColor(node, bestColor);
        bfsSources.reset();
        while (bfsSources.hasNext()) {
            int source = bfsSources.next();
            this.setColor(source, bestColor);
        }
    }

    private void setColor(int node, int color) {
        int current;
        while (color >= (current = this.colors.get(node)) && !this.colors.compareAndSet(node, current, color)) {
        }
    }

    public static class Result {
        public final long nodeId;
        public final long color;

        public Result(long nodeId, int color) {
            this.nodeId = nodeId;
            this.color = color;
        }
    }
}

