/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import com.carrotsearch.hppc.BitSet;
import org.neo4j.graphalgo.api.BothRelationshipIterator;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.api.RelationshipConsumer;
import org.neo4j.graphalgo.api.RelationshipWeights;
import org.neo4j.graphalgo.core.utils.RawValues;
import org.neo4j.graphalgo.core.utils.container.UndirectedTree;
import org.neo4j.graphalgo.core.utils.queue.LongMinPriorityQueue;
import org.neo4j.graphalgo.impl.Algorithm;

public class MSTPrim
extends Algorithm<MSTPrim> {
    private IdMapping idMapping;
    private BothRelationshipIterator iterator;
    private RelationshipWeights weights;
    private MinimumSpanningTree minimumSpanningTree;

    public MSTPrim(IdMapping idMapping, BothRelationshipIterator iterator, RelationshipWeights weights) {
        this.idMapping = idMapping;
        this.iterator = iterator;
        this.weights = weights;
    }

    public MSTPrim compute(int startNode) {
        LongMinPriorityQueue queue = new LongMinPriorityQueue();
        int nodeCount = Math.toIntExact(this.idMapping.nodeCount());
        BitSet visited = new BitSet(nodeCount);
        this.minimumSpanningTree = new MinimumSpanningTree(nodeCount, startNode, this.weights);
        visited.set(startNode);
        this.iterator.forEachRelationship(startNode, (sourceNodeId, targetNodeId, relationId) -> {
            queue.add(RawValues.combineIntInt(startNode, targetNodeId), this.weights.weightOf(sourceNodeId, targetNodeId));
            return true;
        });
        while (!queue.isEmpty() && this.running()) {
            long transition = queue.pop();
            int nodeId = RawValues.getTail(transition);
            if (visited.get(nodeId)) continue;
            visited.set(nodeId);
            this.minimumSpanningTree.addRelationship(RawValues.getHead(transition), nodeId);
            this.iterator.forEachRelationship(nodeId, (sourceNodeId, targetNodeId, relationId) -> {
                queue.add(RawValues.combineIntInt(nodeId, targetNodeId), this.weights.weightOf(sourceNodeId, targetNodeId));
                return true;
            });
        }
        return this;
    }

    public MinimumSpanningTree getMinimumSpanningTree() {
        return this.minimumSpanningTree;
    }

    @Override
    public MSTPrim me() {
        return this;
    }

    @Override
    public MSTPrim release() {
        this.idMapping = null;
        this.iterator = null;
        this.weights = null;
        this.minimumSpanningTree = null;
        return null;
    }

    public static class MinimumSpanningTree
    extends UndirectedTree {
        private final int startNodeId;
        private final RelationshipWeights weights;

        public MinimumSpanningTree(int capacity, int startNodeId, RelationshipWeights weights) {
            super(capacity);
            this.startNodeId = startNodeId;
            this.weights = weights;
        }

        public int getStartNodeId() {
            return this.startNodeId;
        }

        public void forEachBFS(RelationshipConsumer consumer) {
            super.forEachBFS(this.startNodeId, consumer);
        }

        public void forEachDFS(RelationshipConsumer consumer) {
            super.forEachDFS(this.startNodeId, consumer);
        }

        public Aggregator aggregate() {
            Aggregator aggregator = new Aggregator(this.weights);
            this.forEachBFS(aggregator);
            return aggregator;
        }

        public static class Aggregator
        implements RelationshipConsumer {
            private final RelationshipWeights relationshipWeights;
            private double sum = 0.0;
            private double min = Double.MAX_VALUE;
            private double max = Double.MIN_VALUE;
            private int count;

            private Aggregator(RelationshipWeights relationshipWeights) {
                this.relationshipWeights = relationshipWeights;
            }

            @Override
            public boolean accept(int sourceNodeId, int targetNodeId, long relationId) {
                double weight = this.relationshipWeights.weightOf(sourceNodeId, targetNodeId);
                if (weight < this.min) {
                    this.min = weight;
                }
                if (weight > this.max) {
                    this.max = weight;
                }
                ++this.count;
                this.sum += weight;
                return true;
            }

            public double getSum() {
                return this.sum;
            }

            public double getMin() {
                return this.min;
            }

            public double getMax() {
                return this.max;
            }

            public int getCount() {
                return this.count;
            }
        }
    }
}

