/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import com.carrotsearch.hppc.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.graphalgo.api.Degrees;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.api.NodeIterator;
import org.neo4j.graphalgo.api.RelationshipConsumer;
import org.neo4j.graphalgo.api.RelationshipIterator;
import org.neo4j.graphalgo.core.utils.ArrayUtil;
import org.neo4j.graphalgo.core.utils.ParallelUtil;
import org.neo4j.graphalgo.core.utils.Pools;
import org.neo4j.graphalgo.core.write.DoubleArrayTranslator;
import org.neo4j.graphalgo.core.write.Exporter;
import org.neo4j.graphalgo.core.write.PropertyTranslator;
import org.neo4j.graphalgo.impl.Algorithm;
import org.neo4j.graphalgo.impl.PageRankAlgorithm;
import org.neo4j.graphalgo.impl.PageRankResult;
import org.neo4j.graphdb.Direction;

public class PageRank
extends Algorithm<PageRank>
implements PageRankAlgorithm {
    private final ComputeSteps computeSteps;

    PageRank(IdMapping idMapping, NodeIterator nodeIterator, RelationshipIterator relationshipIterator, Degrees degrees, double dampingFactor) {
        this(null, -1, 10000, idMapping, nodeIterator, relationshipIterator, degrees, dampingFactor);
    }

    PageRank(ExecutorService executor, int concurrency, int batchSize, IdMapping idMapping, NodeIterator nodeIterator, RelationshipIterator relationshipIterator, Degrees degrees, double dampingFactor) {
        List<Partition> partitions;
        if (ParallelUtil.canRunInParallel(executor)) {
            partitions = this.partitionGraph(this.adjustBatchSize(batchSize), idMapping, nodeIterator, degrees);
        } else {
            executor = null;
            partitions = this.createSinglePartition(idMapping, degrees);
        }
        this.computeSteps = this.createComputeSteps(concurrency, dampingFactor, relationshipIterator, degrees, partitions, executor);
    }

    @Override
    public PageRank compute(int iterations) {
        assert (iterations >= 1);
        this.computeSteps.run(iterations);
        return this;
    }

    @Override
    public PageRankResult result() {
        return this.computeSteps.getPageRank();
    }

    @Override
    public Algorithm<?> algorithm() {
        return this;
    }

    private int adjustBatchSize(int batchSize) {
        return (batchSize <<= 3) > 0 ? batchSize : Integer.MAX_VALUE;
    }

    private List<Partition> partitionGraph(int batchSize, IdMapping idMapping, NodeIterator nodeIterator, Degrees degrees) {
        int nodeCount = Math.toIntExact(idMapping.nodeCount());
        PrimitiveIntIterator nodes = nodeIterator.nodeIterator();
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        int start = 0;
        while (nodes.hasNext()) {
            Partition partition = new Partition(nodeCount, nodes, degrees, start, batchSize);
            partitions.add(partition);
            start += partition.nodeCount;
        }
        return partitions;
    }

    private List<Partition> createSinglePartition(IdMapping idMapping, Degrees degrees) {
        return Collections.singletonList(new Partition(Math.toIntExact(idMapping.nodeCount()), null, degrees, 0, -1));
    }

    private ComputeSteps createComputeSteps(int concurrency, double dampingFactor, RelationshipIterator relationshipIterator, Degrees degrees, List<Partition> partitions, ExecutorService pool) {
        if (concurrency <= 0) {
            concurrency = Pools.DEFAULT_QUEUE_SIZE;
        }
        int expectedParallelism = Math.min(concurrency, partitions.size());
        ArrayList<ComputeStep> computeSteps = new ArrayList<ComputeStep>(expectedParallelism);
        IntArrayList starts = new IntArrayList(expectedParallelism);
        IntArrayList lengths = new IntArrayList(expectedParallelism);
        int partitionsPerThread = ParallelUtil.threadSize(concurrency + 1, partitions.size());
        Iterator<Partition> parts = partitions.iterator();
        while (parts.hasNext()) {
            Partition partition = parts.next();
            int partitionCount = partition.nodeCount;
            int start = partition.startNode;
            for (int i = 1; i < partitionsPerThread && parts.hasNext(); ++i) {
                partition = parts.next();
                partitionCount += partition.nodeCount;
            }
            starts.add(start);
            lengths.add(partitionCount);
            computeSteps.add(new ComputeStep(dampingFactor, relationshipIterator, degrees, partitionCount, start));
        }
        int[] startArray = starts.toArray();
        int[] lengthArray = lengths.toArray();
        for (ComputeStep computeStep : computeSteps) {
            computeStep.setStarts(startArray, lengthArray);
        }
        return new ComputeSteps(concurrency, computeSteps, pool);
    }

    @Override
    public PageRank me() {
        return this;
    }

    @Override
    public PageRank release() {
        this.computeSteps.release();
        return this;
    }

    private static final class PrimitiveDoubleArrayResult
    implements PageRankResult {
        private final double[] result;

        private PrimitiveDoubleArrayResult(double[] result) {
            this.result = result;
        }

        @Override
        public double score(int nodeId) {
            return this.result[nodeId];
        }

        @Override
        public double score(long nodeId) {
            return this.score((int)nodeId);
        }

        @Override
        public void export(String propertyName, Exporter exporter) {
            exporter.write(propertyName, this.result, DoubleArrayTranslator.INSTANCE);
        }
    }

    private static final class PartitionedPrimitiveDoubleArrayResult
    implements PageRankResult,
    PropertyTranslator.OfDouble<double[][]> {
        private final double[][] partitions;
        private final int[] starts;

        private PartitionedPrimitiveDoubleArrayResult(double[][] partitions, int[] starts) {
            this.partitions = partitions;
            this.starts = starts;
        }

        @Override
        public void export(String propertyName, Exporter exporter) {
            exporter.write(propertyName, this.partitions, this);
        }

        @Override
        public double toDouble(double[][] data, long nodeId) {
            int idx = ArrayUtil.binaryLookup((int)nodeId, this.starts);
            return data[idx][(int)(nodeId - (long)this.starts[idx])];
        }

        @Override
        public double score(int nodeId) {
            int idx = ArrayUtil.binaryLookup(nodeId, this.starts);
            return this.partitions[idx][nodeId - this.starts[idx]];
        }

        @Override
        public double score(long nodeId) {
            return this.toDouble(this.partitions, nodeId);
        }
    }

    private static final class ComputeStep
    implements Runnable,
    RelationshipConsumer {
        private static final int S_INIT = 0;
        private static final int S_CALC = 1;
        private static final int S_SYNC = 2;
        private int state;
        private int[] starts;
        private int[] lengths;
        private final RelationshipIterator relationshipIterator;
        private final Degrees degrees;
        private final double alpha;
        private final double dampingFactor;
        private double[] pageRank;
        private double[] deltas;
        private int[][] nextScores;
        private int[][] prevScores;
        private final int partitionSize;
        private final int startNode;
        private final int endNode;
        private int srcRankDelta = 0;

        ComputeStep(double dampingFactor, RelationshipIterator relationshipIterator, Degrees degrees, int partitionSize, int startNode) {
            this.dampingFactor = dampingFactor;
            this.alpha = 1.0 - dampingFactor;
            this.relationshipIterator = relationshipIterator;
            this.degrees = degrees;
            this.partitionSize = partitionSize;
            this.startNode = startNode;
            this.endNode = startNode + partitionSize;
            this.state = 0;
        }

        void setStarts(int[] starts, int[] lengths) {
            this.starts = starts;
            this.lengths = lengths;
        }

        @Override
        public void run() {
            if (this.state == 1) {
                this.singleIteration();
                this.state = 2;
            } else if (this.state == 2) {
                this.synchronizeScores(this.combineScores());
                this.state = 1;
            } else if (this.state == 0) {
                this.initialize();
                this.state = 1;
            }
        }

        private void initialize() {
            this.nextScores = new int[this.starts.length][];
            Arrays.setAll(this.nextScores, i -> new int[this.lengths[i]]);
            double[] partitionRank = new double[this.partitionSize];
            Arrays.fill(partitionRank, this.alpha);
            this.pageRank = partitionRank;
            this.deltas = Arrays.copyOf(partitionRank, this.partitionSize);
        }

        private void singleIteration() {
            int startNode = this.startNode;
            int endNode = this.endNode;
            RelationshipIterator rels = this.relationshipIterator;
            for (int nodeId = startNode; nodeId < endNode; ++nodeId) {
                int degree;
                double delta = this.deltas[nodeId - startNode];
                if (!(delta > 0.0) || (degree = this.degrees.degree(nodeId, Direction.OUTGOING)) <= 0) continue;
                this.srcRankDelta = (int)(100000.0 * (delta / (double)degree));
                rels.forEachRelationship(nodeId, Direction.OUTGOING, this);
            }
        }

        @Override
        public boolean accept(int sourceNodeId, int targetNodeId, long relationId) {
            if (this.srcRankDelta != 0) {
                int idx = ArrayUtil.binaryLookup(targetNodeId, this.starts);
                int[] nArray = this.nextScores[idx];
                int n = targetNodeId - this.starts[idx];
                nArray[n] = nArray[n] + this.srcRankDelta;
            }
            return true;
        }

        void prepareNextIteration(int[][] prevScores) {
            this.prevScores = prevScores;
        }

        private int[] combineScores() {
            assert (this.prevScores != null);
            assert (this.prevScores.length >= 1);
            int[][] prevScores = this.prevScores;
            int length = prevScores.length;
            int[] allScores = prevScores[0];
            for (int i = 1; i < length; ++i) {
                int[] scores = prevScores[i];
                for (int j = 0; j < scores.length; ++j) {
                    int n = j;
                    allScores[n] = allScores[n] + scores[j];
                    scores[j] = 0;
                }
            }
            return allScores;
        }

        private void synchronizeScores(int[] allScores) {
            double dampingFactor = this.dampingFactor;
            double[] pageRank = this.pageRank;
            int length = allScores.length;
            for (int i = 0; i < length; ++i) {
                int sum = allScores[i];
                double delta = dampingFactor * ((double)sum / 100000.0);
                int n = i;
                pageRank[n] = pageRank[n] + delta;
                this.deltas[i] = delta;
                allScores[i] = 0;
            }
        }
    }

    private final class ComputeSteps {
        private final int concurrency;
        private List<ComputeStep> steps;
        private final ExecutorService pool;
        private int[][][] scores;

        private ComputeSteps(int concurrency, List<ComputeStep> steps, ExecutorService pool) {
            assert (!steps.isEmpty());
            this.concurrency = concurrency;
            this.steps = steps;
            this.pool = pool;
            int stepSize = steps.size();
            this.scores = new int[stepSize][][];
            Arrays.setAll(this.scores, i -> new int[stepSize][]);
        }

        PageRankResult getPageRank() {
            ComputeStep firstStep = this.steps.get(0);
            if (this.steps.size() == 1) {
                return new PrimitiveDoubleArrayResult(firstStep.pageRank);
            }
            double[][] results = new double[this.steps.size()][];
            Iterator<ComputeStep> iterator = this.steps.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                results[i++] = iterator.next().pageRank;
            }
            return new PartitionedPrimitiveDoubleArrayResult(results, firstStep.starts);
        }

        private void run(int iterations) {
            ParallelUtil.runWithConcurrency(this.concurrency, this.steps, this.pool);
            for (int i = 0; i < iterations && PageRank.this.running(); ++i) {
                ParallelUtil.runWithConcurrency(this.concurrency, this.steps, this.pool);
                this.synchronizeScores();
                ParallelUtil.runWithConcurrency(this.concurrency, this.steps, this.pool);
            }
        }

        private void synchronizeScores() {
            int stepSize = this.steps.size();
            int[][][] scores = this.scores;
            for (int i = 0; i < stepSize; ++i) {
                this.synchronizeScores(this.steps.get(i), i, scores);
            }
        }

        private void synchronizeScores(ComputeStep step, int idx, int[][][] scores) {
            step.prepareNextIteration(scores[idx]);
            for (int[] scores[j][idx] : step.nextScores) {
            }
        }

        void release() {
            this.steps.clear();
            this.steps = null;
            this.scores = null;
        }
    }

    private static final class Partition {
        private final int startNode;
        private final int nodeCount;

        Partition(int allNodeCount, PrimitiveIntIterator nodes, Degrees degrees, int startNode, int batchSize) {
            int nodeCount;
            if (batchSize > 0) {
                int nodeId;
                nodeCount = 0;
                for (int partitionSize = 0; partitionSize < batchSize && nodes.hasNext(); partitionSize += degrees.degree(nodeId, Direction.OUTGOING)) {
                    nodeId = nodes.next();
                    ++nodeCount;
                }
            } else {
                nodeCount = allNodeCount;
            }
            this.startNode = startNode;
            this.nodeCount = nodeCount;
        }
    }
}

