/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import java.util.concurrent.ExecutorService;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.HugeGraph;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.impl.Algorithm;
import org.neo4j.graphalgo.impl.HugePageRank;
import org.neo4j.graphalgo.impl.PageRank;
import org.neo4j.graphalgo.impl.PageRankResult;

public interface PageRankAlgorithm {
    public PageRankAlgorithm compute(int var1);

    public PageRankResult result();

    public Algorithm<?> algorithm();

    public static PageRankAlgorithm of(Graph graph, double dampingFactor) {
        return PageRankAlgorithm.of(AllocationTracker.EMPTY, graph, dampingFactor);
    }

    public static PageRankAlgorithm of(AllocationTracker tracker, Graph graph, double dampingFactor) {
        if (graph instanceof HugeGraph) {
            HugeGraph huge = (HugeGraph)graph;
            return new HugePageRank(tracker, huge, huge, huge, huge, dampingFactor);
        }
        return new PageRank(graph, graph, graph, graph, dampingFactor);
    }

    public static PageRankAlgorithm of(Graph graph, double dampingFactor, ExecutorService pool, int concurrency, int batchSize) {
        return PageRankAlgorithm.of(AllocationTracker.EMPTY, graph, dampingFactor, pool, concurrency, batchSize);
    }

    public static PageRankAlgorithm of(AllocationTracker tracker, Graph graph, double dampingFactor, ExecutorService pool, int concurrency, int batchSize) {
        if (graph instanceof HugeGraph) {
            HugeGraph huge = (HugeGraph)graph;
            return new HugePageRank(pool, concurrency, batchSize, tracker, huge, huge, huge, huge, dampingFactor);
        }
        return new PageRank(pool, concurrency, batchSize, graph, graph, graph, graph, dampingFactor);
    }
}

