/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import com.carrotsearch.hppc.IntArrayDeque;
import com.carrotsearch.hppc.IntStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.utils.AtomicDoubleArray;
import org.neo4j.graphalgo.core.utils.ParallelUtil;
import org.neo4j.graphalgo.core.utils.container.Paths;
import org.neo4j.graphalgo.impl.Algorithm;
import org.neo4j.graphalgo.impl.BetweennessCentrality;
import org.neo4j.graphdb.Direction;

public class ParallelBetweennessCentrality
extends Algorithm<ParallelBetweennessCentrality> {
    private Graph graph;
    private volatile AtomicInteger nodeQueue = new AtomicInteger();
    private AtomicDoubleArray centrality;
    private final int nodeCount;
    private final ExecutorService executorService;
    private final int concurrency;
    private Direction direction = Direction.OUTGOING;
    private double divisor = 1.0;

    public ParallelBetweennessCentrality(Graph graph, double scaleFactor, ExecutorService executorService, int concurrency) {
        this.graph = graph;
        this.nodeCount = Math.toIntExact(graph.nodeCount());
        this.executorService = executorService;
        this.concurrency = concurrency;
        this.centrality = new AtomicDoubleArray(this.nodeCount, scaleFactor);
    }

    public ParallelBetweennessCentrality withDirection(Direction direction) {
        this.direction = direction;
        this.divisor = direction == Direction.BOTH ? 2.0 : 1.0;
        return this;
    }

    public ParallelBetweennessCentrality compute() {
        this.nodeQueue.set(0);
        ArrayList futures = new ArrayList();
        for (int i = 0; i < this.concurrency; ++i) {
            futures.add(this.executorService.submit(new BCTask()));
        }
        ParallelUtil.awaitTermination(futures);
        return this;
    }

    public AtomicDoubleArray getCentrality() {
        return this.centrality;
    }

    public Stream<BetweennessCentrality.Result> resultStream() {
        return IntStream.range(0, this.nodeCount).mapToObj(nodeId -> new BetweennessCentrality.Result(this.graph.toOriginalNodeId(nodeId), this.centrality.get(nodeId)));
    }

    @Override
    public ParallelBetweennessCentrality me() {
        return this;
    }

    @Override
    public ParallelBetweennessCentrality release() {
        this.graph = null;
        this.centrality = null;
        return null;
    }

    private class BCTask
    implements Runnable {
        private final Paths paths = new Paths();
        private final IntStack stack = new IntStack();
        private final IntArrayDeque queue = new IntArrayDeque();
        private final double[] delta;
        private final int[] sigma;
        private final int[] distance;

        private BCTask() {
            this.sigma = new int[ParallelBetweennessCentrality.this.nodeCount];
            this.distance = new int[ParallelBetweennessCentrality.this.nodeCount];
            this.delta = new double[ParallelBetweennessCentrality.this.nodeCount];
        }

        @Override
        public void run() {
            block0: while (true) {
                int node;
                this.reset();
                int startNodeId = ParallelBetweennessCentrality.this.nodeQueue.getAndIncrement();
                if (startNodeId >= ParallelBetweennessCentrality.this.nodeCount || !ParallelBetweennessCentrality.this.running()) {
                    return;
                }
                ParallelBetweennessCentrality.this.getProgressLogger().logProgress((double)startNodeId / (double)(ParallelBetweennessCentrality.this.nodeCount - 1));
                this.sigma[startNodeId] = 1;
                this.distance[startNodeId] = 0;
                this.queue.addLast(startNodeId);
                while (!this.queue.isEmpty()) {
                    node = this.queue.removeFirst();
                    this.stack.push(node);
                    ParallelBetweennessCentrality.this.graph.forEachRelationship(node, ParallelBetweennessCentrality.this.direction, (source, target, relationId) -> {
                        if (this.distance[target] < 0) {
                            this.queue.addLast(target);
                            this.distance[target] = this.distance[node] + 1;
                        }
                        if (this.distance[target] == this.distance[node] + 1) {
                            int n = target;
                            this.sigma[n] = this.sigma[n] + this.sigma[node];
                            this.paths.append(target, node);
                        }
                        return true;
                    });
                }
                while (true) {
                    if (this.stack.isEmpty()) continue block0;
                    node = this.stack.pop();
                    this.paths.forEach(node, v -> {
                        int n = v;
                        this.delta[n] = this.delta[n] + (double)this.sigma[v] / (double)this.sigma[node] * (this.delta[node] + 1.0);
                        return true;
                    });
                    if (node == startNodeId) continue;
                    ParallelBetweennessCentrality.this.centrality.addCapped(node, this.delta[node] / ParallelBetweennessCentrality.this.divisor);
                }
                break;
            }
        }

        private void reset() {
            this.paths.clear();
            this.stack.clear();
            this.queue.clear();
            Arrays.fill(this.sigma, 0);
            Arrays.fill(this.delta, 0.0);
            Arrays.fill(this.distance, -1);
        }
    }
}

