/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import java.util.ArrayList;
import java.util.Stack;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import java.util.function.Consumer;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.utils.ParallelUtil;
import org.neo4j.graphalgo.core.utils.dss.DisjointSetStruct;
import org.neo4j.graphalgo.impl.Algorithm;
import org.neo4j.graphdb.Direction;

public class ParallelUnionFindFJMerge
extends Algorithm<ParallelUnionFindFJMerge> {
    private Graph graph;
    private final ExecutorService executor;
    private final int nodeCount;
    private final int batchSize;
    private DisjointSetStruct struct;

    public ParallelUnionFindFJMerge(Graph graph, ExecutorService executor, int minBatchSize, int concurrency) {
        this.graph = graph;
        this.executor = executor;
        this.nodeCount = Math.toIntExact(graph.nodeCount());
        this.batchSize = ParallelUtil.adjustBatchSize(this.nodeCount, concurrency, minBatchSize);
    }

    public ParallelUnionFindFJMerge compute() {
        ArrayList<UFProcess> ufProcesses = new ArrayList<UFProcess>();
        for (int i = 0; i < this.nodeCount; i += this.batchSize) {
            ufProcesses.add(new UFProcess(i, this.batchSize));
        }
        this.merge(ufProcesses);
        return this;
    }

    public ParallelUnionFindFJMerge compute(double threshold) {
        ArrayList<TUFProcess> ufProcesses = new ArrayList<TUFProcess>();
        for (int i = 0; i < this.nodeCount; i += this.batchSize) {
            ufProcesses.add(new TUFProcess(i, this.batchSize, threshold));
        }
        this.merge(ufProcesses);
        return this;
    }

    public void merge(ArrayList<? extends UFProcess> ufProcesses) {
        ParallelUtil.run(ufProcesses, this.executor);
        if (!this.running()) {
            return;
        }
        Stack temp = new Stack();
        ufProcesses.forEach((Consumer<? extends UFProcess>)((Consumer<UFProcess>)uf -> temp.add(uf.struct)));
        this.struct = ForkJoinPool.commonPool().invoke(new Merge(temp));
    }

    public DisjointSetStruct getStruct() {
        return this.struct;
    }

    @Override
    public ParallelUnionFindFJMerge me() {
        return this;
    }

    @Override
    public ParallelUnionFindFJMerge release() {
        this.graph = null;
        this.struct = null;
        return this;
    }

    private class Merge
    extends RecursiveTask<DisjointSetStruct> {
        private final Stack<DisjointSetStruct> structs;

        private Merge(Stack<DisjointSetStruct> structs) {
            this.structs = structs;
        }

        @Override
        protected DisjointSetStruct compute() {
            int size = this.structs.size();
            if (size == 1) {
                return this.structs.pop();
            }
            if (!ParallelUnionFindFJMerge.this.running()) {
                return this.structs.pop();
            }
            if (size == 2) {
                return this.merge(this.structs.pop(), this.structs.pop());
            }
            Stack<DisjointSetStruct> list = new Stack<DisjointSetStruct>();
            list.push(this.structs.pop());
            list.push(this.structs.pop());
            Merge mergeA = new Merge(this.structs);
            Merge mergeB = new Merge(list);
            mergeA.fork();
            DisjointSetStruct computed = mergeB.compute();
            return this.merge((DisjointSetStruct)mergeA.join(), computed);
        }

        private DisjointSetStruct merge(DisjointSetStruct a, DisjointSetStruct b) {
            return a.merge(b);
        }
    }

    private class TUFProcess
    extends UFProcess {
        private final double threshold;

        public TUFProcess(int offset, int length, double threshold) {
            super(offset, length);
            this.threshold = threshold;
        }

        @Override
        public void run() {
            for (int node = this.offset; node < this.end && node < ParallelUnionFindFJMerge.this.nodeCount && ParallelUnionFindFJMerge.this.running(); ++node) {
                ParallelUnionFindFJMerge.this.graph.forEachRelationship(node, Direction.OUTGOING, (sourceNodeId, targetNodeId, relationId, weight) -> {
                    if (weight > this.threshold) {
                        this.struct.union(sourceNodeId, targetNodeId);
                    }
                    return true;
                });
            }
        }
    }

    private class UFProcess
    implements Runnable {
        protected final int offset;
        protected final int end;
        protected final DisjointSetStruct struct;

        public UFProcess(int offset, int length) {
            this.offset = offset;
            this.end = offset + length;
            this.struct = new DisjointSetStruct(ParallelUnionFindFJMerge.this.nodeCount).reset();
        }

        @Override
        public void run() {
            for (int node = this.offset; node < this.end && node < ParallelUnionFindFJMerge.this.nodeCount && ParallelUnionFindFJMerge.this.running(); ++node) {
                try {
                    ParallelUnionFindFJMerge.this.graph.forEachRelationship(node, Direction.OUTGOING, (sourceNodeId, targetNodeId, relationId) -> {
                        if (!this.struct.connected(sourceNodeId, targetNodeId)) {
                            this.struct.union(sourceNodeId, targetNodeId);
                        }
                        return true;
                    });
                    continue;
                }
                catch (Exception e) {
                    System.out.println("exception for nodeid:" + node);
                    e.printStackTrace();
                    return;
                }
            }
            ParallelUnionFindFJMerge.this.getProgressLogger().logProgress((this.end - 1) / (ParallelUnionFindFJMerge.this.nodeCount - 1));
        }
    }
}

