/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.utils.ParallelUtil;
import org.neo4j.graphalgo.core.utils.dss.DisjointSetStruct;
import org.neo4j.graphalgo.impl.Algorithm;
import org.neo4j.graphdb.Direction;

public class ParallelUnionFindForkJoin
extends Algorithm<ParallelUnionFindForkJoin> {
    private Graph graph;
    private final ExecutorService executor;
    private final int nodeCount;
    private final int batchSize;
    private DisjointSetStruct struct;

    public ParallelUnionFindForkJoin(Graph graph, ExecutorService executor, int minBatchSize, int concurrency) {
        this.graph = graph;
        this.executor = executor;
        this.nodeCount = Math.toIntExact(graph.nodeCount());
        this.batchSize = ParallelUtil.adjustBatchSize(this.nodeCount, concurrency, minBatchSize);
    }

    public ParallelUnionFindForkJoin compute() {
        this.struct = ForkJoinPool.commonPool().invoke(new UnionFindTask(0));
        return this;
    }

    public ParallelUnionFindForkJoin compute(double threshold) {
        this.struct = ForkJoinPool.commonPool().invoke(new ThresholdUFTask(0, threshold));
        return this;
    }

    public DisjointSetStruct getStruct() {
        return this.struct;
    }

    @Override
    public ParallelUnionFindForkJoin me() {
        return this;
    }

    @Override
    public ParallelUnionFindForkJoin release() {
        this.graph = null;
        return null;
    }

    private class ThresholdUFTask
    extends UnionFindTask {
        private final double threshold;

        public ThresholdUFTask(int offset, double threshold) {
            super(offset);
            this.threshold = threshold;
        }

        @Override
        protected DisjointSetStruct run() {
            DisjointSetStruct struct = new DisjointSetStruct(ParallelUnionFindForkJoin.this.nodeCount).reset();
            for (int node = this.offset; node < this.end && ParallelUnionFindForkJoin.this.running(); ++node) {
                ParallelUnionFindForkJoin.this.graph.forEachRelationship(node, Direction.OUTGOING, (sourceNodeId, targetNodeId, relationId, weight) -> {
                    if (weight < this.threshold) {
                        return true;
                    }
                    if (!struct.connected(sourceNodeId, targetNodeId)) {
                        struct.union(sourceNodeId, targetNodeId);
                    }
                    return true;
                });
            }
            return struct;
        }
    }

    private class UnionFindTask
    extends RecursiveTask<DisjointSetStruct> {
        protected final int offset;
        protected final int end;

        public UnionFindTask(int offset) {
            this.offset = offset;
            this.end = Math.min(offset + ParallelUnionFindForkJoin.this.batchSize, ParallelUnionFindForkJoin.this.nodeCount);
        }

        @Override
        protected DisjointSetStruct compute() {
            if (ParallelUnionFindForkJoin.this.nodeCount - this.end >= ParallelUnionFindForkJoin.this.batchSize && ParallelUnionFindForkJoin.this.running()) {
                UnionFindTask process = new UnionFindTask(this.end);
                process.fork();
                return this.run().merge((DisjointSetStruct)process.join());
            }
            return this.run();
        }

        protected DisjointSetStruct run() {
            DisjointSetStruct struct = new DisjointSetStruct(ParallelUnionFindForkJoin.this.nodeCount).reset();
            for (int node = this.offset; node < this.end && ParallelUnionFindForkJoin.this.running(); ++node) {
                ParallelUnionFindForkJoin.this.graph.forEachRelationship(node, Direction.OUTGOING, (sourceNodeId, targetNodeId, relationId) -> {
                    if (!struct.connected(sourceNodeId, targetNodeId)) {
                        struct.union(sourceNodeId, targetNodeId);
                    }
                    return true;
                });
            }
            ParallelUnionFindForkJoin.this.getProgressLogger().logProgress((double)(this.end - 1), ParallelUnionFindForkJoin.this.nodeCount - 1);
            return struct;
        }
    }
}

