/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.utils.ParallelUtil;
import org.neo4j.graphalgo.core.utils.dss.DisjointSetStruct;
import org.neo4j.graphalgo.impl.Algorithm;
import org.neo4j.graphdb.Direction;

public class ParallelUnionFindQueue
extends Algorithm<ParallelUnionFindQueue> {
    private Graph graph;
    private final ExecutorService executor;
    private final int nodeCount;
    private final int batchSize;
    private final LinkedBlockingQueue<DisjointSetStruct> queue;
    private final List<Future<?>> futures;
    private DisjointSetStruct struct;

    public ParallelUnionFindQueue(Graph graph, ExecutorService executor, int minBatchSize, int concurrency) {
        this.graph = graph;
        this.executor = executor;
        this.nodeCount = Math.toIntExact(graph.nodeCount());
        this.batchSize = ParallelUtil.adjustBatchSize(this.nodeCount, concurrency, minBatchSize);
        this.queue = new LinkedBlockingQueue();
        this.futures = new ArrayList();
    }

    public ParallelUnionFindQueue compute() {
        int i;
        int steps = Math.floorDiv(this.nodeCount, this.batchSize) - 1;
        for (i = 0; i < this.nodeCount; i += this.batchSize) {
            this.futures.add(this.executor.submit(new UnionFindTask(i)));
        }
        for (i = steps - 1; i >= 0; --i) {
            this.futures.add(this.executor.submit(() -> {
                try {
                    DisjointSetStruct a = this.queue.take();
                    DisjointSetStruct b = this.queue.take();
                    this.queue.add(a.merge(b));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }));
        }
        this.await();
        return this;
    }

    private void await() {
        ParallelUtil.awaitTermination(this.futures);
    }

    public ParallelUnionFindQueue compute(double threshold) {
        throw new IllegalArgumentException("Not yet implemented");
    }

    public DisjointSetStruct getStruct() {
        try {
            return this.queue.take();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ParallelUnionFindQueue me() {
        return this;
    }

    @Override
    public ParallelUnionFindQueue release() {
        this.graph = null;
        return null;
    }

    private class UnionFindTask
    implements Runnable {
        protected final int offset;
        protected final int end;

        public UnionFindTask(int offset) {
            this.offset = offset;
            this.end = Math.min(offset + ParallelUnionFindQueue.this.batchSize, ParallelUnionFindQueue.this.nodeCount);
        }

        @Override
        public void run() {
            DisjointSetStruct struct = new DisjointSetStruct(ParallelUnionFindQueue.this.nodeCount).reset();
            for (int node = this.offset; node < this.end; ++node) {
                ParallelUnionFindQueue.this.graph.forEachRelationship(node, Direction.OUTGOING, (sourceNodeId, targetNodeId, relationId) -> {
                    if (!struct.connected(sourceNodeId, targetNodeId)) {
                        struct.union(sourceNodeId, targetNodeId);
                    }
                    return true;
                });
            }
            ParallelUnionFindQueue.this.getProgressLogger().logProgress(((double)this.end - 1.0) / ((double)ParallelUnionFindQueue.this.nodeCount - 1.0));
            ParallelUnionFindQueue.this.queue.add(struct);
        }
    }
}

