/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import com.carrotsearch.hppc.IntStack;
import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.impl.Algorithm;
import org.neo4j.graphalgo.results.SCCStreamResult;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.impl.util.collection.SimpleBitSet;

public class SCCIterativeTarjan
extends Algorithm<SCCIterativeTarjan> {
    private Graph graph;
    private final int nodeCount;
    private int[] index;
    private SimpleBitSet visited;
    private int[] connectedComponents;
    private IntStack stack;
    private IntStack boundaries;
    private IntStack todo;
    private int setCount;
    private int minSetSize;
    private int maxSetSize;

    public SCCIterativeTarjan(Graph graph) {
        this.graph = graph;
        this.nodeCount = Math.toIntExact(graph.nodeCount());
        this.index = new int[this.nodeCount];
        this.stack = new IntStack();
        this.boundaries = new IntStack();
        this.connectedComponents = new int[this.nodeCount];
        this.visited = new SimpleBitSet(this.nodeCount);
        this.todo = new IntStack();
    }

    public SCCIterativeTarjan compute() {
        this.setCount = 0;
        this.minSetSize = Integer.MAX_VALUE;
        this.maxSetSize = 0;
        Arrays.fill(this.index, -1);
        Arrays.fill(this.connectedComponents, -1);
        this.todo.clear();
        this.boundaries.clear();
        this.stack.clear();
        this.graph.forEachNode(this::compute);
        return this;
    }

    @Override
    public SCCIterativeTarjan me() {
        return this;
    }

    @Override
    public SCCIterativeTarjan release() {
        this.graph = null;
        this.index = null;
        this.visited = null;
        this.connectedComponents = null;
        this.stack = null;
        this.boundaries = null;
        this.todo = null;
        return this;
    }

    public int[] getConnectedComponents() {
        return this.connectedComponents;
    }

    public Stream<SCCStreamResult> resultStream() {
        return IntStream.range(0, this.nodeCount).filter(i -> this.connectedComponents[i] != -1).mapToObj(i -> new SCCStreamResult(this.graph.toOriginalNodeId(i), this.connectedComponents[i]));
    }

    public int getSetCount() {
        return this.setCount;
    }

    public int getMinSetSize() {
        return this.minSetSize;
    }

    public int getMaxSetSize() {
        return this.maxSetSize;
    }

    private boolean compute(int nodeId) {
        if (!this.running()) {
            return false;
        }
        if (this.index[nodeId] != -1) {
            return true;
        }
        this.push(Action.VISIT, nodeId);
        while (!this.todo.isEmpty()) {
            int action = this.todo.pop();
            int node = this.todo.pop();
            if (action == Action.VISIT.code) {
                this.visit(node);
                continue;
            }
            if (action == Action.VISITEDGE.code) {
                this.visitEdge(node);
                continue;
            }
            this.postVisit(node);
        }
        this.getProgressLogger().logProgress((double)nodeId / (double)(this.nodeCount - 1));
        return true;
    }

    private void visitEdge(int nodeId) {
        if (this.index[nodeId] == -1) {
            this.push(Action.VISIT, nodeId);
        } else if (!this.visited.contains(nodeId)) {
            while (this.index[nodeId] < this.boundaries.peek()) {
                this.boundaries.pop();
            }
        }
    }

    private void postVisit(int nodeId) {
        if (this.boundaries.peek() == this.index[nodeId]) {
            int element;
            this.boundaries.pop();
            int elementCount = 0;
            do {
                element = this.stack.pop();
                this.connectedComponents[element] = nodeId;
                this.visited.put(element);
                ++elementCount;
            } while (element != nodeId);
            this.minSetSize = Math.min(this.minSetSize, elementCount);
            this.maxSetSize = Math.max(this.maxSetSize, elementCount);
            ++this.setCount;
        }
    }

    private void visit(int nodeId) {
        int stackSize;
        this.index[nodeId] = stackSize = this.stack.size();
        this.stack.push(nodeId);
        this.boundaries.push(stackSize);
        this.push(Action.POSTVISIT, nodeId);
        this.graph.forEachRelationship(nodeId, Direction.OUTGOING, (sourceNodeId, targetNodeId, relationId) -> {
            this.push(Action.VISITEDGE, targetNodeId);
            return true;
        });
    }

    private void push(Action action, int value) {
        this.todo.push(value);
        this.todo.push(action.code);
    }

    private static enum Action {
        VISIT(0),
        VISITEDGE(1),
        POSTVISIT(2);

        public final int code;

        private Action(int code) {
            this.code = code;
        }
    }
}

