/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.IntStack;
import com.carrotsearch.hppc.ObjectArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.function.IntPredicate;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.RelationshipConsumer;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.impl.Algorithm;
import org.neo4j.graphdb.Direction;

public class SCCTarjan
extends Algorithm<SCCTarjan> {
    private Graph graph;
    private final int nodeCount;
    private Aggregator aggregator;

    public SCCTarjan(Graph graph) {
        this.graph = graph;
        this.nodeCount = Math.toIntExact(graph.nodeCount());
        this.aggregator = new Aggregator(graph, new int[this.nodeCount], new int[this.nodeCount], new ObjectArrayList(), new BitSet(this.nodeCount), new IntStack(this.nodeCount));
    }

    public SCCTarjan compute() {
        this.aggregator.reset();
        this.graph.forEachNode(this.aggregator);
        return this;
    }

    public ObjectArrayList<IntSet> getConnectedComponents() {
        return this.aggregator.connectedComponents;
    }

    public long getMaxSetSize() {
        return this.graph.nodeCount() == 0L ? 0L : this.aggregator.maxSetSize;
    }

    public long getMinSetSize() {
        return this.graph.nodeCount() == 0L ? 0L : this.aggregator.minSetSize;
    }

    @Override
    public SCCTarjan me() {
        return this;
    }

    @Override
    public SCCTarjan release() {
        this.aggregator = null;
        this.graph = null;
        return this;
    }

    private final class Aggregator
    implements IntPredicate,
    RelationshipConsumer {
        private final Graph graph;
        private final int[] indices;
        private final int[] lowLink;
        private final ObjectArrayList<IntSet> connectedComponents;
        private final BitSet onStack;
        private final IntStack stack;
        private int index;
        private long minSetSize = Long.MAX_VALUE;
        private long maxSetSize = 0L;
        private ProgressLogger progressLogger;

        private Aggregator(Graph graph, int[] indices, int[] lowLink, ObjectArrayList<IntSet> connectedComponents, BitSet onStack, IntStack stack) {
            this.graph = graph;
            this.indices = indices;
            this.lowLink = lowLink;
            this.connectedComponents = connectedComponents;
            this.onStack = onStack;
            this.stack = stack;
            this.progressLogger = SCCTarjan.this.getProgressLogger();
        }

        public void reset() {
            this.connectedComponents.clear();
            Arrays.fill(this.indices, -1);
            Arrays.fill(this.lowLink, -1);
            this.onStack.clear();
            this.stack.clear();
            this.index = 0;
            this.minSetSize = Long.MAX_VALUE;
            this.maxSetSize = 0L;
        }

        private void strongConnect(int node) {
            this.lowLink[node] = this.index;
            this.indices[node] = this.index++;
            this.stack.push(node);
            this.onStack.set(node);
            this.graph.forEachRelationship(node, Direction.OUTGOING, this);
            if (this.indices[node] == this.lowLink[node]) {
                this.relax(node);
            }
        }

        private void relax(int nodeId) {
            int w;
            IntHashSet connected = new IntHashSet();
            do {
                w = this.stack.pop();
                this.onStack.clear(w);
                connected.add(w);
            } while (w != nodeId);
            this.connectedComponents.add(connected);
            int size = connected.size();
            if ((long)size < this.minSetSize) {
                this.minSetSize = size;
            }
            if ((long)size > this.maxSetSize) {
                this.maxSetSize = size;
            }
        }

        @Override
        public boolean accept(int source, int target, long edgeId) {
            if (this.indices[target] == -1) {
                this.strongConnect(target);
                this.lowLink[source] = Math.min(this.lowLink[source], this.lowLink[target]);
            } else if (this.onStack.get(target)) {
                this.lowLink[source] = Math.min(this.lowLink[source], this.indices[target]);
            }
            return true;
        }

        @Override
        public boolean test(int node) {
            if (this.indices[node] == -1) {
                this.strongConnect(node);
            }
            this.progressLogger.logProgress((double)node / (double)(SCCTarjan.this.nodeCount - 1));
            return SCCTarjan.this.running();
        }
    }
}

