/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import com.carrotsearch.hppc.IntStack;
import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.impl.Algorithm;
import org.neo4j.graphalgo.results.SCCStreamResult;
import org.neo4j.graphdb.Direction;

public class SCCTunedTarjan
extends Algorithm<SCCTunedTarjan> {
    private Graph graph;
    private IntStack edgeStack;
    private IntStack open;
    private int[] connectedComponents;
    private int nodeCount;
    private int dfs = 0;
    private int setCount = 0;
    private int minSetSize = Integer.MAX_VALUE;
    private int maxSetSize = 0;

    public SCCTunedTarjan(Graph graph) {
        this.graph = graph;
        this.nodeCount = Math.toIntExact(graph.nodeCount());
        this.connectedComponents = new int[this.nodeCount];
        this.edgeStack = new IntStack();
        this.open = new IntStack();
    }

    public SCCTunedTarjan compute() {
        ProgressLogger progressLogger = this.getProgressLogger();
        Arrays.fill(this.connectedComponents, -1);
        this.setCount = 0;
        this.dfs = 0;
        this.setCount = 0;
        this.maxSetSize = 0;
        this.minSetSize = Integer.MAX_VALUE;
        this.dfs = -(this.nodeCount + 1);
        this.graph.forEachNode(node -> {
            if (this.connectedComponents[node] == -1) {
                this.lowPointDFS(node);
            }
            progressLogger.logProgress((double)node / (double)(this.nodeCount - 1));
            return this.running();
        });
        return this;
    }

    public int[] getConnectedComponents() {
        return this.connectedComponents;
    }

    public Stream<SCCStreamResult> resultStream() {
        return IntStream.range(0, this.nodeCount).filter(i -> this.connectedComponents[i] != -1).mapToObj(i -> new SCCStreamResult(this.graph.toOriginalNodeId(i), this.connectedComponents[i]));
    }

    public int getSetCount() {
        return this.setCount;
    }

    public int getMinSetSize() {
        return this.minSetSize;
    }

    public int getMaxSetSize() {
        return this.maxSetSize;
    }

    private int lowPointDFS(int nodeId) {
        int dfsNum;
        this.connectedComponents[nodeId] = dfsNum = this.dfs++;
        int lowPoint = dfsNum;
        this.open.push(nodeId);
        int sz = this.edgeStack.size();
        this.graph.forEachRelationship(nodeId, Direction.OUTGOING, (sourceNodeId, targetNodeId, relationId) -> {
            this.edgeStack.push(targetNodeId);
            return true;
        });
        while (this.edgeStack.size() > sz) {
            int w = this.edgeStack.pop();
            int d = this.connectedComponents[w];
            if (d == -1) {
                d = this.lowPointDFS(w);
            }
            if (d >= lowPoint) continue;
            lowPoint = d;
        }
        if (dfsNum == lowPoint) {
            int element;
            int elementCount = 0;
            do {
                element = this.open.pop();
                this.connectedComponents[element] = this.setCount++;
                ++elementCount;
            } while (element != nodeId);
            this.minSetSize = Math.min(this.minSetSize, elementCount);
            this.maxSetSize = Math.max(this.maxSetSize, elementCount);
        }
        return lowPoint;
    }

    @Override
    public SCCTunedTarjan me() {
        return this;
    }

    @Override
    public SCCTunedTarjan release() {
        this.graph = null;
        this.edgeStack = null;
        this.open = null;
        this.connectedComponents = null;
        return this;
    }
}

