/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.utils.ParallelUtil;
import org.neo4j.graphalgo.core.utils.container.Buckets;
import org.neo4j.graphalgo.impl.Algorithm;
import org.neo4j.graphdb.Direction;

public class ShortestPathDeltaStepping
extends Algorithm<ShortestPathDeltaStepping> {
    private AtomicIntegerArray distance;
    private Buckets buckets;
    private Graph graph;
    private Collection<Runnable> light;
    private Collection<Runnable> heavy;
    private Collection<Future<?>> futures;
    private final double delta;
    private final int nodeCount;
    private int iDelta;
    private ExecutorService executorService;
    private double multiplier = 100000.0;

    public ShortestPathDeltaStepping(Graph graph, double delta) {
        this.graph = graph;
        this.delta = delta;
        this.iDelta = (int)(this.multiplier * delta);
        this.nodeCount = Math.toIntExact(graph.nodeCount());
        this.distance = new AtomicIntegerArray(this.nodeCount);
        this.buckets = new Buckets(this.nodeCount);
        this.heavy = new ArrayDeque<Runnable>(1024);
        this.light = new ArrayDeque<Runnable>(1024);
        this.futures = new ArrayDeque(128);
    }

    public ShortestPathDeltaStepping withExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public ShortestPathDeltaStepping withMultiplier(int multiplier) {
        if (multiplier < 1) {
            throw new IllegalArgumentException("multiplier must be >= 1");
        }
        this.multiplier = multiplier;
        this.iDelta = (int)((double)multiplier * this.delta);
        return this;
    }

    public ShortestPathDeltaStepping compute(long startNode) {
        for (int i = 0; i < this.nodeCount; ++i) {
            this.distance.set(i, Integer.MAX_VALUE);
        }
        this.buckets.reset();
        this.relax(this.graph.toMappedNodeId(startNode), 0);
        while (!this.buckets.isEmpty() && this.running()) {
            this.light.clear();
            this.heavy.clear();
            int phase = this.buckets.nextNonEmptyBucket();
            this.buckets.forEachInBucket(phase, node -> {
                this.graph.forEachRelationship(node, Direction.OUTGOING, (sourceNodeId, targetNodeId, relationId, cost) -> {
                    int iCost = (int)(cost * this.multiplier + (double)this.distance.get(sourceNodeId));
                    if (cost <= this.delta) {
                        this.light.add(() -> this.relax(targetNodeId, iCost));
                    } else {
                        this.heavy.add(() -> this.relax(targetNodeId, iCost));
                    }
                    return true;
                });
                return true;
            });
            ParallelUtil.run(this.light, this.executorService, this.futures);
            ParallelUtil.run(this.heavy, this.executorService, this.futures);
        }
        return this;
    }

    private double get(int nodeId) {
        return (double)this.distance.get(nodeId) / this.multiplier;
    }

    private void cas(int nodeId, int cost) {
        int oldC;
        boolean stored = false;
        while (!stored && cost < (oldC = this.distance.get(nodeId))) {
            stored = this.distance.compareAndSet(nodeId, oldC, cost);
        }
    }

    private void relax(int nodeId, int cost) {
        if (cost >= this.distance.get(nodeId)) {
            return;
        }
        int bucketIndex = cost / this.iDelta;
        this.buckets.set(nodeId, bucketIndex);
        this.cas(nodeId, cost);
    }

    public double[] getShortestPaths() {
        double[] d = new double[this.nodeCount];
        for (int i = this.nodeCount - 1; i >= 0; --i) {
            d[i] = this.get(i);
        }
        return d;
    }

    public Stream<DeltaSteppingResult> resultStream() {
        return IntStream.range(0, this.nodeCount).mapToObj(node -> new DeltaSteppingResult(this.graph.toOriginalNodeId(node), this.get(node)));
    }

    @Override
    public ShortestPathDeltaStepping me() {
        return this;
    }

    @Override
    public ShortestPathDeltaStepping release() {
        this.distance = null;
        this.buckets = null;
        this.graph = null;
        this.light = null;
        this.heavy = null;
        this.futures = null;
        return null;
    }

    public static class DeltaSteppingResult {
        public final long nodeId;
        public final double distance;

        public DeltaSteppingResult(long nodeId, double distance) {
            this.nodeId = nodeId;
            this.distance = distance;
        }

        public String toString() {
            return "DeltaSteppingResult{nodeId=" + this.nodeId + ", distance=" + this.distance + '}';
        }
    }
}

