/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import com.carrotsearch.hppc.IntArrayDeque;
import com.carrotsearch.hppc.IntDoubleMap;
import com.carrotsearch.hppc.IntDoubleScatterMap;
import com.carrotsearch.hppc.IntIntMap;
import com.carrotsearch.hppc.IntIntScatterMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.queue.IntPriorityQueue;
import org.neo4j.graphalgo.core.utils.queue.SharedIntMinPriorityQueue;
import org.neo4j.graphalgo.core.utils.traverse.SimpleBitSet;
import org.neo4j.graphalgo.impl.Algorithm;
import org.neo4j.graphdb.Direction;

public class ShortestPathDijkstra
extends Algorithm<ShortestPathDijkstra> {
    private static final int PATH_END = -1;
    public static final double NO_PATH_FOUND = -1.0;
    private Graph graph;
    private IntDoubleMap costs;
    private IntPriorityQueue queue;
    private IntIntMap path;
    private IntArrayDeque finalPath;
    private SimpleBitSet visited;
    private final int nodeCount;
    private double totalCost;
    private ProgressLogger progressLogger;

    public ShortestPathDijkstra(Graph graph) {
        this.graph = graph;
        this.nodeCount = Math.toIntExact(graph.nodeCount());
        this.costs = new IntDoubleScatterMap(this.nodeCount);
        this.queue = new SharedIntMinPriorityQueue(this.nodeCount, this.costs, Double.MAX_VALUE);
        this.path = new IntIntScatterMap(this.nodeCount);
        this.visited = new SimpleBitSet(this.nodeCount);
        this.finalPath = new IntArrayDeque();
        this.progressLogger = this.getProgressLogger();
    }

    public ShortestPathDijkstra compute(long startNode, long goalNode) {
        return this.compute(startNode, goalNode, Direction.BOTH);
    }

    public ShortestPathDijkstra compute(long startNode, long goalNode, Direction direction) {
        this.reset();
        int node = this.graph.toMappedNodeId(startNode);
        int goal = this.graph.toMappedNodeId(goalNode);
        this.costs.put(node, 0.0);
        this.queue.add(node, 0.0);
        this.run(goal, direction);
        if (!this.path.containsKey(goal)) {
            return this;
        }
        this.totalCost = this.costs.get(goal);
        int last = goal;
        while (last != -1) {
            this.finalPath.addFirst(last);
            last = this.path.getOrDefault(last, -1);
        }
        return this;
    }

    public Stream<Result> resultStream() {
        return StreamSupport.stream(this.finalPath.spliterator(), false).map(cursor -> new Result(this.graph.toOriginalNodeId(cursor.value), this.costs.get(cursor.value)));
    }

    public IntArrayDeque getFinalPath() {
        return this.finalPath;
    }

    public double getTotalCost() {
        return this.totalCost;
    }

    public int getPathLength() {
        return this.finalPath.size();
    }

    private void run(int goal, Direction direction) {
        while (!this.queue.isEmpty() && this.running()) {
            int node = this.queue.pop();
            if (node == goal) {
                return;
            }
            this.visited.put(node);
            double costs = this.costs.getOrDefault(node, Double.MAX_VALUE);
            this.graph.forEachRelationship(node, direction, (source, target, relId, weight) -> {
                this.updateCosts(source, target, weight + costs);
                if (!this.visited.contains(target)) {
                    this.queue.add(target, 0.0);
                }
                return true;
            });
            this.progressLogger.logProgress((double)node / (double)(this.nodeCount - 1));
        }
    }

    private void updateCosts(int source, int target, double newCosts) {
        double oldCosts = this.costs.getOrDefault(target, Double.MAX_VALUE);
        if (newCosts < oldCosts) {
            this.costs.put(target, newCosts);
            this.path.put(target, source);
        }
    }

    @Override
    public ShortestPathDijkstra me() {
        return this;
    }

    @Override
    public ShortestPathDijkstra release() {
        this.graph = null;
        this.costs = null;
        this.queue = null;
        this.path = null;
        this.finalPath = null;
        this.visited = null;
        return this;
    }

    private void reset() {
        this.visited.clear();
        this.queue.clear();
        this.costs.clear();
        this.path.clear();
        this.finalPath.clear();
        this.totalCost = -1.0;
    }

    public static class Result {
        public final Long nodeId;
        public final Double cost;

        public Result(Long nodeId, Double cost) {
            this.nodeId = nodeId;
            this.cost = cost;
        }
    }
}

