/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import com.carrotsearch.hppc.IntDoubleMap;
import com.carrotsearch.hppc.IntDoubleScatterMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.queue.IntMinPriorityQueue;
import org.neo4j.graphalgo.impl.Algorithm;
import org.neo4j.graphdb.Direction;

public class ShortestPaths
extends Algorithm<ShortestPaths> {
    private Graph graph;
    private IntDoubleMap costs;
    private IntMinPriorityQueue queue;
    private final int nodeCount;
    private ProgressLogger progressLogger;

    public ShortestPaths(Graph graph) {
        this.graph = graph;
        this.nodeCount = Math.toIntExact(graph.nodeCount());
        this.costs = new IntDoubleScatterMap(this.nodeCount);
        this.queue = new IntMinPriorityQueue();
        this.progressLogger = this.getProgressLogger();
    }

    public ShortestPaths compute(long startNode) {
        this.graph.forEachNode(node -> {
            this.costs.put(node, Double.POSITIVE_INFINITY);
            return true;
        });
        int nodeId = this.graph.toMappedNodeId(startNode);
        this.costs.put(nodeId, 0.0);
        this.queue.add(nodeId, 0.0);
        this.run();
        return this;
    }

    public IntDoubleMap getShortestPaths() {
        return this.costs;
    }

    public Stream<Result> resultStream() {
        return StreamSupport.stream(this.costs.spliterator(), false).map(cursor -> new Result(this.graph.toOriginalNodeId(cursor.key), cursor.value));
    }

    private void run() {
        while (!this.queue.isEmpty() && this.running()) {
            int node = this.queue.pop();
            double sourceCosts = this.costs.getOrDefault(node, Double.POSITIVE_INFINITY);
            this.graph.forEachRelationship(node, Direction.OUTGOING, (source, target, relId, weight) -> {
                double targetCosts = this.costs.getOrDefault(target, Double.POSITIVE_INFINITY);
                if (weight + sourceCosts < targetCosts) {
                    this.costs.put(target, weight + sourceCosts);
                    this.queue.add(target, targetCosts);
                }
                return true;
            });
            this.progressLogger.logProgress((double)node / (double)(this.nodeCount - 1));
        }
    }

    @Override
    public ShortestPaths me() {
        return this;
    }

    @Override
    public ShortestPaths release() {
        this.graph = null;
        this.costs = null;
        this.queue = null;
        return this;
    }

    public static class Result {
        public final long nodeId;
        public final double distance;

        public Result(Long nodeId, Double distance) {
            this.nodeId = nodeId;
            this.distance = distance;
        }
    }
}

