/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.utils.ParallelUtil;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.impl.Algorithm;
import org.neo4j.graphdb.Direction;

public class TriangleCount
extends Algorithm<TriangleCount> {
    public static final Direction D = Direction.BOTH;
    private Graph graph;
    private ExecutorService executorService;
    private final int concurrency;
    private final int nodeCount;
    private final AtomicInteger visitedNodes;
    private final AtomicInteger triangleCount;
    private AtomicIntegerArray triangles;
    private double averageClusteringCoefficient;

    public TriangleCount(Graph graph, ExecutorService executorService, int concurrency) {
        this.graph = graph;
        this.executorService = executorService;
        this.concurrency = concurrency;
        this.nodeCount = Math.toIntExact(graph.nodeCount());
        this.triangles = new AtomicIntegerArray(this.nodeCount);
        this.triangleCount = new AtomicInteger();
        this.visitedNodes = new AtomicInteger();
    }

    public Stream<Result> resultStream() {
        return IntStream.range(0, this.nodeCount).mapToObj(i -> new Result(this.graph.toOriginalNodeId(i), this.triangles.get(i), this.calculateCoefficient(this.triangles.get(i), this.graph.degree(i, D))));
    }

    public int getTriangleCount() {
        return this.triangleCount.get();
    }

    public AtomicIntegerArray getTriangles() {
        return this.triangles;
    }

    @Override
    public TriangleCount me() {
        return this;
    }

    @Override
    public TriangleCount release() {
        this.graph = null;
        this.executorService = null;
        this.triangles = null;
        return this;
    }

    public TriangleCount compute() {
        this.visitedNodes.set(0);
        this.triangleCount.set(0);
        this.averageClusteringCoefficient = 0.0;
        ArrayList<Task> tasks = new ArrayList<Task>();
        int batchSize = ParallelUtil.adjustBatchSize(this.nodeCount, this.concurrency, 1);
        for (int i = 0; i < this.nodeCount; i += batchSize) {
            tasks.add(new Task(i, Math.min(i + batchSize, this.nodeCount)));
        }
        ParallelUtil.run(tasks, this.executorService);
        return this;
    }

    public double[] getClusteringCoefficients() {
        double[] coefficient = new double[this.nodeCount];
        double sum = 0.0;
        for (int i = 0; i < this.nodeCount; ++i) {
            double c;
            coefficient[i] = c = this.calculateCoefficient(this.triangles.get(i), this.graph.degree(i, D));
            sum += c;
        }
        this.averageClusteringCoefficient = sum / (double)this.nodeCount;
        return coefficient;
    }

    public double getAverageClusteringCoefficient() {
        return this.averageClusteringCoefficient;
    }

    private void exportTriangle(int u, int v, int w) {
        this.triangleCount.incrementAndGet();
        this.triangles.incrementAndGet(u);
        this.triangles.incrementAndGet(v);
        this.triangles.incrementAndGet(w);
    }

    private double calculateCoefficient(int triangles, int degree) {
        if (triangles == 0) {
            return 0.0;
        }
        return 2.0 * (double)triangles / (double)(degree * (degree - 1));
    }

    public static class Result {
        public final long nodeId;
        public final long triangles;
        public final double coefficient;

        public Result(long nodeId, long triangles, double coefficient) {
            this.nodeId = nodeId;
            this.triangles = triangles;
            this.coefficient = coefficient;
        }

        public String toString() {
            return "Result{nodeId=" + this.nodeId + ", triangles=" + this.triangles + ", coefficient=" + this.coefficient + '}';
        }
    }

    private class Task
    implements Runnable {
        private final int startIndex;
        private final int endIndex;

        private Task(int startIndex, int endIndex) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        @Override
        public void run() {
            TerminationFlag flag = TriangleCount.this.getTerminationFlag();
            ProgressLogger progressLogger = TriangleCount.this.getProgressLogger();
            for (int i = this.startIndex; i < this.endIndex; ++i) {
                TriangleCount.this.graph.forEachRelationship(i, D, (u, v, relationId) -> {
                    if (u >= v) {
                        return true;
                    }
                    if (!flag.running()) {
                        return false;
                    }
                    TriangleCount.this.graph.forEachRelationship(v, D, (v2, w, relationId2) -> {
                        if (v2 >= w) {
                            return true;
                        }
                        if (!flag.running()) {
                            return false;
                        }
                        TriangleCount.this.graph.forEachRelationship(w, D, (sourceNodeId3, t, relationId3) -> {
                            if (t == u) {
                                TriangleCount.this.exportTriangle(u, v, w);
                                return false;
                            }
                            return flag.running();
                        });
                        return true;
                    });
                    return true;
                });
                progressLogger.logProgress((double)TriangleCount.this.visitedNodes.incrementAndGet(), TriangleCount.this.nodeCount);
            }
        }
    }
}

