/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl;

import java.util.Objects;
import org.neo4j.graphalgo.api.AllRelationshipIterator;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.api.IntBinaryPredicate;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.dss.DisjointSetStruct;
import org.neo4j.graphalgo.impl.Algorithm;

public class UnionFind
extends Algorithm<UnionFind> {
    private AllRelationshipIterator iterator;
    private final int nodeCount;
    private int stepCount;

    public UnionFind(IdMapping idMapping, AllRelationshipIterator iterator) {
        this.iterator = iterator;
        this.nodeCount = Math.toIntExact(idMapping.nodeCount());
    }

    public DisjointSetStruct compute(IntBinaryPredicate constraint) {
        Objects.requireNonNull(constraint);
        ProgressLogger progressLogger = this.getProgressLogger();
        DisjointSetStruct dss = new DisjointSetStruct(this.nodeCount);
        dss.reset();
        this.stepCount = 0;
        this.iterator.forEachRelationship((source, target, relationship) -> {
            if (constraint.test(source, target)) {
                dss.union(source, target);
            }
            ++this.stepCount;
            progressLogger.logProgress((double)this.stepCount / (double)(this.nodeCount - 1));
            return this.running();
        });
        return dss;
    }

    public DisjointSetStruct compute() {
        DisjointSetStruct dss = new DisjointSetStruct(this.nodeCount);
        ProgressLogger progressLogger = this.getProgressLogger();
        dss.reset();
        this.stepCount = 0;
        this.iterator.forEachRelationship((source, target, relationship) -> {
            dss.union(source, target);
            ++this.stepCount;
            progressLogger.logProgress((double)this.stepCount / (double)(this.nodeCount - 1));
            return this.running();
        });
        return dss;
    }

    @Override
    public UnionFind me() {
        return this;
    }

    @Override
    public UnionFind release() {
        this.iterator = null;
        return this;
    }
}

