/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.louvain;

import com.carrotsearch.hppc.IntIntScatterMap;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.IntObjectScatterMap;
import com.carrotsearch.hppc.IntScatterSet;
import com.carrotsearch.hppc.IntSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.api.RelationshipIterator;
import org.neo4j.graphalgo.api.RelationshipWeights;
import org.neo4j.graphalgo.core.utils.ParallelUtil;
import org.neo4j.graphalgo.impl.Algorithm;
import org.neo4j.graphdb.Direction;

public class Louvain
extends Algorithm<Louvain> {
    private RelationshipIterator relationshipIterator;
    private RelationshipWeights relationshipWeights;
    private ExecutorService executorService;
    private final int concurrency;
    private final int nodeCount;
    private final int[] communityIds;
    private IntObjectMap<IntSet> communities;
    private final IdMapping idMapping;
    private double m2;
    private int iterations;

    public Louvain(IdMapping idMapping, RelationshipIterator relationshipIterator, RelationshipWeights relationshipWeights, ExecutorService executorService, int concurrency) {
        this.idMapping = idMapping;
        this.nodeCount = Math.toIntExact(idMapping.nodeCount());
        this.relationshipIterator = relationshipIterator;
        this.relationshipWeights = relationshipWeights;
        this.executorService = executorService;
        this.concurrency = concurrency;
        this.communityIds = new int[this.nodeCount];
        this.communities = new IntObjectScatterMap<IntSet>();
    }

    public Louvain compute(int iterations) {
        this.reset();
        for (int i = 0; i < iterations; ++i) {
            if (this.arrange()) continue;
            return this;
        }
        return this;
    }

    public Stream<Result> resultStream() {
        return IntStream.range(0, this.nodeCount).mapToObj(i -> new Result(this.idMapping.toOriginalNodeId(i), this.communityIds[i]));
    }

    public double communityModularity() {
        double[] mod = new double[]{0.0};
        this.communities.keys().forEach(c -> {
            double[] sInAndsTot = this.sInAndsTot(c);
            mod[0] = mod[0] + (sInAndsTot[0] / this.m2 - Math.pow(sInAndsTot[1] / this.m2, 2.0));
        });
        return mod[0];
    }

    public int[] getCommunityIds() {
        return this.communityIds;
    }

    public IntObjectMap<IntSet> getCommunities() {
        return this.communities;
    }

    public int getIterations() {
        return this.iterations;
    }

    public int getCommunityCount() {
        IntIntScatterMap map = new IntIntScatterMap();
        for (int i = 0; i < this.communityIds.length; ++i) {
            map.addTo(this.communityIds[i], 1);
        }
        return map.size();
    }

    @Override
    public Louvain me() {
        return this;
    }

    @Override
    public Louvain release() {
        this.relationshipIterator = null;
        this.relationshipWeights = null;
        this.executorService = null;
        this.communities = null;
        return this;
    }

    private void reset() {
        this.iterations = 1;
        this.communities.clear();
        for (int i = 0; i < this.nodeCount; ++i) {
            IntScatterSet set = new IntScatterSet();
            set.add(i);
            this.communities.put(i, set);
            this.communityIds[i] = i;
        }
        DoubleAdder adder = new DoubleAdder();
        ParallelUtil.iterateParallel(this.executorService, this.nodeCount, this.concurrency, node -> this.relationshipIterator.forEachRelationship(node, Direction.OUTGOING, (sourceNodeId, targetNodeId, relationId) -> {
            adder.add(this.relationshipWeights.weightOf(sourceNodeId, targetNodeId));
            return true;
        }));
        this.m2 = adder.doubleValue() * 2.0;
    }

    private void assign(int node, int sourceCommunity, int targetCommunity) {
        this.communities.get(sourceCommunity).removeAll(node);
        this.communities.get(targetCommunity).add(node);
        this.communityIds[node] = targetCommunity;
    }

    private double[] sInAndsTot(int community) {
        IntSet set = this.communities.get(community);
        double[] sum = new double[]{0.0, 0.0};
        set.forEach(node -> {
            int nodeCommunity = this.communityIds[node];
            this.relationshipIterator.forEachRelationship(node, Direction.BOTH, (sourceNodeId, targetNodeId, relationId) -> {
                double weight = this.relationshipWeights.weightOf(sourceNodeId, targetNodeId);
                if (sourceNodeId < targetNodeId && this.communityIds[targetNodeId] == nodeCommunity) {
                    sum[0] = sum[0] + weight;
                }
                sum[1] = sum[1] + weight;
                return true;
            });
        });
        return sum;
    }

    private double[] kIAndkIIn(int node, int targetCommunity) {
        double[] sum = new double[]{0.0, 0.0};
        this.relationshipIterator.forEachRelationship(node, Direction.BOTH, (sourceNodeId, targetNodeId, relationId) -> {
            double weight = this.relationshipWeights.weightOf(sourceNodeId, targetNodeId);
            sum[0] = sum[0] + weight;
            if (targetCommunity == this.communityIds[targetNodeId]) {
                sum[1] = sum[1] + weight;
            }
            return true;
        });
        return sum;
    }

    private double modGain(int node, int targetCommunity) {
        double[] sInTot = this.sInAndsTot(targetCommunity);
        double[] kIAndkIIn = this.kIAndkIIn(node, targetCommunity);
        return (sInTot[0] + kIAndkIIn[1]) / this.m2 - Math.pow((sInTot[1] + kIAndkIIn[0]) / this.m2, 2.0) - (sInTot[0] / this.m2 - Math.pow(sInTot[1] / this.m2, 2.0) - Math.pow(kIAndkIIn[0] / this.m2, 2.0));
    }

    private boolean arrange() {
        boolean[] changes = new boolean[]{false};
        double[] bestGain = new double[]{0.0};
        int[] bestCommunity = new int[]{0};
        for (int node = 0; node < this.nodeCount; ++node) {
            int currentCommunity;
            bestGain[0] = Double.MIN_VALUE;
            bestCommunity[0] = currentCommunity = this.communityIds[node];
            this.relationshipIterator.forEachRelationship(node, Direction.BOTH, (sourceNodeId, targetNodeId, relationId) -> {
                int targetCommunity = this.communityIds[targetNodeId];
                double gain = this.modGain(sourceNodeId, targetCommunity);
                if (gain > bestGain[0]) {
                    bestCommunity[0] = targetCommunity;
                    bestGain[0] = gain;
                }
                return true;
            });
            if (bestCommunity[0] == currentCommunity || !(bestGain[0] > 0.0)) continue;
            this.assign(node, currentCommunity, bestCommunity[0]);
            changes[0] = true;
        }
        return changes[0];
    }

    public static class Result {
        public final long nodeId;
        public final long community;

        public Result(long nodeId, int community) {
            this.nodeId = nodeId;
            this.community = community;
        }

        public String toString() {
            return "Result{nodeId=" + this.nodeId + ", community=" + this.community + '}';
        }
    }
}

