/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.msbfs;

import java.util.Arrays;
import org.neo4j.graphalgo.impl.msbfs.MultiBitSet32;

final class BiMultiBitSet32 {
    private static final long AUX_MASK = -4294967296L;
    private static final long DEF_MASK = 0xFFFFFFFFL;
    private final long[] bits;

    BiMultiBitSet32(int nodeCount) {
        try {
            this.bits = new long[nodeCount];
        }
        catch (NegativeArraySizeException | OutOfMemoryError e) {
            IllegalArgumentException iae = new IllegalArgumentException("Invalid nodeCount: " + nodeCount);
            iae.addSuppressed(e);
            throw iae;
        }
    }

    long get(int nodeId) {
        return this.bits[nodeId];
    }

    void setAuxBit(int nodeId, int bit) {
        assert (bit < 32);
        int n = nodeId;
        this.bits[n] = this.bits[n] | 1L << bit + 32;
    }

    void setAuxBits(int fromId, int len) {
        assert (len <= 32);
        assert (len >= 1);
        Arrays.fill(this.bits, 0L);
        for (int i = 0; i < len; ++i) {
            this.bits[fromId + i] = 1L << i + 32;
        }
    }

    void setAuxBits(int[] nodes) {
        int len = nodes.length;
        assert (len <= 32);
        assert (len >= 1);
        assert (this.isSorted(nodes)) : "aux bits must be sorted";
        Arrays.fill(this.bits, 0L);
        for (int i = 0; i < len; ++i) {
            this.bits[nodes[i]] = 1L << i + 32;
        }
    }

    int nextSetNodeId(int fromNodeId) {
        for (int i = fromNodeId; i < this.bits.length; ++i) {
            if ((int)this.bits[i] == 0) continue;
            return i;
        }
        return -2 + Integer.signum(fromNodeId);
    }

    void union(int nodeId, int bits) {
        int n = nodeId;
        this.bits[n] = this.bits[n] | (long)bits & 0xFFFFFFFFL;
    }

    int unionDifference(int nodeId) {
        long bit = this.bits[nodeId];
        int aux = (int)(bit >>> 32);
        int def = (int)bit;
        def &= ~aux;
        this.bits[nodeId] = bit = (long)(aux |= def) << 32 | (long)def & 0xFFFFFFFFL;
        return def;
    }

    boolean copyInto(MultiBitSet32 target) {
        boolean didCopy = false;
        int length = this.bits.length;
        int i = 0;
        while (i < length) {
            int bit = (int)this.bits[i];
            didCopy = didCopy || bit != 0;
            target.set(i, bit);
            int n = i++;
            this.bits[n] = this.bits[n] & 0xFFFFFFFF00000000L;
        }
        return didCopy;
    }

    private boolean isSorted(int[] nodes) {
        int[] copy = Arrays.copyOf(nodes, nodes.length);
        Arrays.sort(copy);
        return Arrays.equals(copy, nodes);
    }
}

