/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.msbfs;

import java.util.Arrays;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.IntArray;
import org.neo4j.graphalgo.core.utils.paged.LongArray;
import org.neo4j.graphalgo.impl.msbfs.HugeMultiBitSet32;

final class HugeBiMultiBitSet32 {
    private static final long AUX_MASK = -4294967296L;
    private static final long DEF_MASK = 0xFFFFFFFFL;
    private final LongArray bits;
    private final LongArray.Cursor cursor;

    HugeBiMultiBitSet32(long nodeCount, AllocationTracker tracker) {
        try {
            this.bits = LongArray.newArray(nodeCount, tracker);
            this.cursor = this.bits.newCursor();
        }
        catch (OutOfMemoryError e) {
            IllegalArgumentException iae = new IllegalArgumentException("Invalid nodeCount: " + nodeCount);
            iae.addSuppressed(e);
            throw iae;
        }
    }

    long get(long nodeId) {
        return this.bits.get(nodeId);
    }

    void setAuxBit(long nodeId, int bit) {
        assert (bit < 32);
        this.bits.or(nodeId, 1L << bit + 32);
    }

    void setAuxBits(long fromId, int len) {
        assert (len <= 32);
        assert (len >= 1);
        this.bits.fill(0L);
        for (int i = 0; i < len; ++i) {
            this.bits.set(fromId + (long)i, 1L << i + 32);
        }
    }

    void setAuxBits(long[] nodes) {
        int len = nodes.length;
        assert (len <= 32);
        assert (len >= 1);
        assert (this.isSorted(nodes)) : "aux bits must be sorted";
        this.bits.fill(0L);
        for (int i = 0; i < len; ++i) {
            this.bits.set(nodes[i], 1L << i + 32);
        }
    }

    long nextSetNodeId(long fromNodeId) {
        LongArray.Cursor cursor = this.bits.cursor(fromNodeId, this.cursor);
        long n = fromNodeId;
        while (cursor.next()) {
            long[] array = cursor.array;
            int offset = cursor.offset;
            int limit = cursor.limit;
            int i = offset;
            while (i < limit) {
                if ((int)array[i] != 0) {
                    return n;
                }
                ++i;
                ++n;
            }
        }
        return -2 + Long.signum(fromNodeId);
    }

    void union(long nodeId, int bits) {
        this.bits.or(nodeId, (long)bits & 0xFFFFFFFFL);
    }

    int unionDifference(long nodeId) {
        long bit = this.bits.get(nodeId);
        int aux = (int)(bit >>> 32);
        int def = (int)bit;
        def &= ~aux;
        bit = (long)(aux |= def) << 32 | (long)def & 0xFFFFFFFFL;
        this.bits.set(nodeId, bit);
        return def;
    }

    boolean copyInto(HugeMultiBitSet32 target) {
        boolean didCopy = false;
        LongArray.Cursor cursor = this.bits.cursor(0L, this.cursor);
        IntArray.BulkAdder bulkAdder = target.bulkAdder();
        while (cursor.next()) {
            long[] array = cursor.array;
            int offset = cursor.offset;
            int limit = cursor.limit;
            int i = offset;
            while (i < limit) {
                int bit = (int)(array[i] & 0xFFFFFFFFL);
                didCopy = didCopy || bit != 0;
                bulkAdder.add(bit);
                int n = i++;
                array[n] = array[n] & 0xFFFFFFFF00000000L;
            }
        }
        return didCopy;
    }

    private boolean isSorted(long[] nodes) {
        long[] copy = Arrays.copyOf(nodes, nodes.length);
        Arrays.sort(copy);
        return Arrays.equals(copy, nodes);
    }
}

