/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.msbfs;

import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.IntArray;

final class HugeMultiBitSet32 {
    private final long nodeCount;
    private final IntArray bits;
    private final IntArray.Cursor cursor;
    private final IntArray.BulkAdder bulkAdder;

    HugeMultiBitSet32(long nodeCount, AllocationTracker tracker) {
        this.nodeCount = nodeCount;
        try {
            this.bits = IntArray.newArray(this.nodeCount, tracker);
            this.cursor = this.bits.newCursor();
            this.bulkAdder = this.bits.newBulkAdder();
        }
        catch (OutOfMemoryError e) {
            IllegalArgumentException iae = new IllegalArgumentException("Invalid nodeCount: " + nodeCount);
            iae.addSuppressed(e);
            throw iae;
        }
    }

    void setBit(long nodeId, int bit) {
        assert (bit < 32);
        this.bits.or(nodeId, 1 << bit);
    }

    void set(long nodeId, int bit) {
        this.bits.set(nodeId, bit);
    }

    int get(long nodeId) {
        return this.bits.get(nodeId);
    }

    long nextSetNodeId(long fromNodeId) {
        IntArray.Cursor cursor = this.bits.initCursor(fromNodeId, this.nodeCount - fromNodeId, this.cursor);
        long n = fromNodeId;
        while (cursor.next()) {
            int[] array = cursor.array;
            int offset = cursor.offset;
            int limit = cursor.limit;
            int i = offset;
            while (i < limit) {
                if (array[i] != 0) {
                    return n;
                }
                ++i;
                ++n;
            }
        }
        return -2 + Long.signum(fromNodeId);
    }

    IntArray.BulkAdder bulkAdder() {
        this.bulkAdder.init(0L, this.nodeCount);
        return this.bulkAdder;
    }
}

