/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.msbfs;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphalgo.api.HugeIdMapping;
import org.neo4j.graphalgo.api.HugeRelationshipIterator;
import org.neo4j.graphalgo.core.utils.ParallelUtil;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.impl.msbfs.HugeBfsConsumer;
import org.neo4j.graphalgo.impl.msbfs.HugeBfsSources;
import org.neo4j.graphalgo.impl.msbfs.HugeBiMultiBitSet32;
import org.neo4j.graphalgo.impl.msbfs.HugeMultiBitSet32;
import org.neo4j.graphalgo.impl.msbfs.MsBFSAlgo;
import org.neo4j.graphdb.Direction;

public final class HugeMultiSourceBFS
implements Runnable,
MsBFSAlgo {
    static final int OMEGA = 32;
    private final ThreadLocal<HugeMultiBitSet32> visits;
    private final ThreadLocal<HugeBiMultiBitSet32> nextAndSeens;
    private final HugeIdMapping nodeIds;
    private final HugeRelationshipIterator relationships;
    private final Direction direction;
    private final HugeBfsConsumer perNodeAction;
    private final long[] startNodes;
    private long nodeOffset;
    private long nodeCount;
    private int sourceNodeCount;

    public HugeMultiSourceBFS(HugeIdMapping nodeIds, HugeRelationshipIterator relationships, Direction direction, HugeBfsConsumer perNodeAction, AllocationTracker tracker, long ... startNodes) {
        this.nodeIds = nodeIds;
        this.relationships = relationships;
        this.direction = direction;
        this.perNodeAction = perNodeAction;
        long[] lArray = this.startNodes = startNodes != null && startNodes.length > 0 ? startNodes : null;
        if (this.startNodes != null) {
            Arrays.sort(this.startNodes);
        }
        this.nodeCount = nodeIds.nodeCount();
        this.visits = new VisitLocal(this.nodeCount, tracker);
        this.nextAndSeens = new NextAndSeenLocal(this.nodeCount, tracker);
    }

    private HugeMultiSourceBFS(HugeIdMapping nodeIds, HugeRelationshipIterator relationships, Direction direction, HugeBfsConsumer perNodeAction, ThreadLocal<HugeMultiBitSet32> visits, ThreadLocal<HugeBiMultiBitSet32> nextAndSeens, long ... startNodes) {
        assert (startNodes != null && startNodes.length > 0);
        this.nodeIds = nodeIds;
        this.relationships = relationships;
        this.direction = direction;
        this.perNodeAction = perNodeAction;
        this.startNodes = startNodes;
        this.visits = visits;
        this.nextAndSeens = nextAndSeens;
    }

    private HugeMultiSourceBFS(HugeIdMapping nodeIds, HugeRelationshipIterator relationships, Direction direction, HugeBfsConsumer perNodeAction, long nodeOffset, int sourceNodeCount, ThreadLocal<HugeMultiBitSet32> visits, ThreadLocal<HugeBiMultiBitSet32> nextAndSeens) {
        this.nodeIds = nodeIds;
        this.relationships = relationships;
        this.direction = direction;
        this.perNodeAction = perNodeAction;
        this.startNodes = null;
        this.nodeOffset = nodeOffset;
        this.sourceNodeCount = sourceNodeCount;
        this.visits = visits;
        this.nextAndSeens = nextAndSeens;
    }

    @Override
    public void run(int concurrency, ExecutorService executor) {
        int threads = this.numberOfThreads();
        Collection<HugeMultiSourceBFS> bfss = this.allSourceBfss(threads);
        if (!ParallelUtil.canRunInParallel(executor)) {
            executor = null;
        }
        ParallelUtil.runWithConcurrency(concurrency, bfss, threads << 2, 100L, TimeUnit.MICROSECONDS, executor);
    }

    @Override
    public void run() {
        long nodeId;
        int i;
        assert (this.sourceLength() <= 32L) : "more than 32 sources not supported";
        SourceNodes sourceNodes = this.startNodes != null ? new SourceNodes(this.startNodes) : new SourceNodes(this.nodeOffset, this.sourceNodeCount);
        HugeMultiBitSet32 visit = this.visits.get();
        HugeBiMultiBitSet32 nextAndSeen = this.nextAndSeens.get();
        if (this.startNodes != null) {
            nextAndSeen.setAuxBits(this.startNodes);
            for (i = 0; i < this.startNodes.length; ++i) {
                visit.setBit(this.startNodes[i], i);
            }
        } else {
            nextAndSeen.setAuxBits(this.nodeOffset, this.sourceNodeCount);
            for (i = 0; i < this.sourceNodeCount; ++i) {
                visit.setBit((long)i + this.nodeOffset, i);
            }
        }
        int depth = 0;
        do {
            nodeId = -1L;
            while ((nodeId = visit.nextSetNodeId(nodeId + 1L)) >= 0L) {
                int nodeVisit = visit.get(nodeId);
                assert (nodeVisit != 0);
                this.relationships.forEachRelationship(nodeId, this.direction, (src, tgt) -> {
                    nextAndSeen.union(tgt, nodeVisit);
                    return true;
                });
            }
            ++depth;
            nodeId = -1L;
            while ((nodeId = nextAndSeen.nextSetNodeId(nodeId + 1L)) >= 0L) {
                int D = nextAndSeen.unionDifference(nodeId);
                if (D == 0) continue;
                sourceNodes.reset(D);
                this.perNodeAction.accept(nodeId, depth, sourceNodes);
            }
        } while (nodeId != -2L && nextAndSeen.copyInto(visit));
    }

    private long sourceLength() {
        if (this.startNodes != null) {
            return this.startNodes.length;
        }
        if (this.sourceNodeCount == 0) {
            return this.nodeCount;
        }
        return this.sourceNodeCount;
    }

    private int numberOfThreads() {
        long sourceLength = this.sourceLength();
        long threads = ParallelUtil.threadSize(32, sourceLength);
        if ((long)((int)threads) != threads) {
            throw new IllegalArgumentException("Unable run MS-BFS on " + sourceLength + " sources.");
        }
        return (int)threads;
    }

    private Collection<HugeMultiSourceBFS> allSourceBfss(int threads) {
        if (this.startNodes == null) {
            long sourceLength = this.nodeCount;
            return new ParallelMultiSources(threads, sourceLength){

                @Override
                HugeMultiSourceBFS next(long from, int length) {
                    return new HugeMultiSourceBFS(HugeMultiSourceBFS.this.nodeIds, HugeMultiSourceBFS.this.relationships.concurrentCopy(), HugeMultiSourceBFS.this.direction, HugeMultiSourceBFS.this.perNodeAction, from, length, HugeMultiSourceBFS.this.visits, HugeMultiSourceBFS.this.nextAndSeens);
                }
            };
        }
        final long[] startNodes = this.startNodes;
        int sourceLength = startNodes.length;
        return new ParallelMultiSources(threads, sourceLength){

            @Override
            HugeMultiSourceBFS next(long from, int length) {
                return new HugeMultiSourceBFS(HugeMultiSourceBFS.this.nodeIds, HugeMultiSourceBFS.this.relationships.concurrentCopy(), HugeMultiSourceBFS.this.direction, HugeMultiSourceBFS.this.perNodeAction, HugeMultiSourceBFS.this.visits, HugeMultiSourceBFS.this.nextAndSeens, Arrays.copyOfRange(startNodes, (int)from, (int)(from + (long)length)));
            }
        };
    }

    public String toString() {
        if (this.startNodes != null && this.startNodes.length > 0) {
            return "MSBFS{" + this.startNodes[0] + " .. " + (this.startNodes[this.startNodes.length - 1] + 1L) + " (" + this.startNodes.length + ")}";
        }
        return "MSBFS{" + this.nodeOffset + " .. " + (this.nodeOffset + (long)this.sourceNodeCount) + " (" + this.sourceNodeCount + ")}";
    }

    private static final class NextAndSeenLocal
    extends ThreadLocal<HugeBiMultiBitSet32> {
        private final long nodeCount;
        private final AllocationTracker tracker;

        private NextAndSeenLocal(long nodeCount, AllocationTracker tracker) {
            this.nodeCount = nodeCount;
            this.tracker = tracker;
        }

        @Override
        protected HugeBiMultiBitSet32 initialValue() {
            return new HugeBiMultiBitSet32(this.nodeCount, this.tracker);
        }
    }

    private static final class VisitLocal
    extends ThreadLocal<HugeMultiBitSet32> {
        private final long nodeCount;
        private final AllocationTracker tracker;

        private VisitLocal(long nodeCount, AllocationTracker tracker) {
            this.nodeCount = nodeCount;
            this.tracker = tracker;
        }

        @Override
        protected HugeMultiBitSet32 initialValue() {
            return new HugeMultiBitSet32(this.nodeCount, this.tracker);
        }
    }

    private static abstract class ParallelMultiSources
    extends AbstractCollection<HugeMultiSourceBFS>
    implements Iterator<HugeMultiSourceBFS> {
        private final int threads;
        private final long sourceLength;
        private long start = 0L;
        private int i = 0;

        private ParallelMultiSources(int threads, long sourceLength) {
            this.threads = threads;
            this.sourceLength = sourceLength;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.threads;
        }

        @Override
        public int size() {
            return this.threads;
        }

        @Override
        public Iterator<HugeMultiSourceBFS> iterator() {
            this.start = 0L;
            this.i = 0;
            return this;
        }

        @Override
        public HugeMultiSourceBFS next() {
            int len = (int)Math.min(32L, this.sourceLength - this.start);
            HugeMultiSourceBFS bfs = this.next(this.start, len);
            this.start += (long)len;
            ++this.i;
            return bfs;
        }

        abstract HugeMultiSourceBFS next(long var1, int var3);
    }

    private static final class SourceNodes
    implements HugeBfsSources {
        private final long[] sourceNodes;
        private final int maxPos;
        private final int startPos;
        private final long offset;
        private int sourceMask;
        private int pos;

        private SourceNodes(long[] sourceNodes) {
            assert (sourceNodes.length <= 32);
            this.sourceNodes = sourceNodes;
            this.maxPos = sourceNodes.length;
            this.offset = 0L;
            this.startPos = -1;
        }

        private SourceNodes(long offset, int length) {
            assert (length <= 32);
            this.sourceNodes = null;
            this.maxPos = length;
            this.offset = offset;
            this.startPos = -1;
        }

        @Override
        public void reset() {
            this.pos = this.startPos;
            this.fetchNext();
        }

        void reset(int sourceMask) {
            this.sourceMask = sourceMask;
            this.reset();
        }

        public boolean hasNext() {
            return this.pos < this.maxPos;
        }

        public long next() {
            int current = this.pos;
            this.fetchNext();
            return this.sourceNodes != null ? this.sourceNodes[current] : (long)current + this.offset;
        }

        @Override
        public int size() {
            return Integer.bitCount(this.sourceMask);
        }

        private void fetchNext() {
            while (++this.pos < this.maxPos && (this.sourceMask & 1 << this.pos) == 0) {
            }
        }
    }
}

