/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.msbfs;

final class MultiBitSet32 {
    private final int[] bits;

    MultiBitSet32(int nodeCount) {
        try {
            this.bits = new int[nodeCount];
        }
        catch (NegativeArraySizeException | OutOfMemoryError e) {
            IllegalArgumentException iae = new IllegalArgumentException("Invalid nodeCount: " + nodeCount);
            iae.addSuppressed(e);
            throw iae;
        }
    }

    void setBit(int nodeId, int bit) {
        assert (bit < 32);
        int n = nodeId;
        this.bits[n] = this.bits[n] | 1 << bit;
    }

    void set(int nodeId, int bit) {
        this.bits[nodeId] = bit;
    }

    int get(int nodeId) {
        return this.bits[nodeId];
    }

    int nextSetNodeId(int fromNodeId) {
        for (int i = fromNodeId; i < this.bits.length; ++i) {
            if (this.bits[i] == 0) continue;
            return i;
        }
        return -2 + Integer.signum(fromNodeId);
    }
}

