/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.msbfs;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.api.RelationshipIterator;
import org.neo4j.graphalgo.core.utils.ParallelUtil;
import org.neo4j.graphalgo.impl.msbfs.BfsConsumer;
import org.neo4j.graphalgo.impl.msbfs.BfsSources;
import org.neo4j.graphalgo.impl.msbfs.BiMultiBitSet32;
import org.neo4j.graphalgo.impl.msbfs.MsBFSAlgo;
import org.neo4j.graphalgo.impl.msbfs.MultiBitSet32;
import org.neo4j.graphdb.Direction;

public final class MultiSourceBFS
implements Runnable,
MsBFSAlgo {
    static final int OMEGA = 32;
    private final ThreadLocal<MultiBitSet32> visits;
    private final ThreadLocal<BiMultiBitSet32> nextAndSeens;
    private final IdMapping nodeIds;
    private final RelationshipIterator relationships;
    private final Direction direction;
    private final BfsConsumer perNodeAction;
    private final int[] startNodes;
    private int nodeOffset;
    private int sourceNodeCount;
    private int nodeCount;

    public MultiSourceBFS(IdMapping nodeIds, RelationshipIterator relationships, Direction direction, BfsConsumer perNodeAction, int ... startNodes) {
        this.nodeIds = nodeIds;
        this.relationships = relationships;
        this.direction = direction;
        this.perNodeAction = perNodeAction;
        int[] nArray = this.startNodes = startNodes != null && startNodes.length > 0 ? startNodes : null;
        if (this.startNodes != null) {
            Arrays.sort(this.startNodes);
        }
        this.nodeCount = Math.toIntExact(nodeIds.nodeCount());
        this.visits = new VisitLocal(this.nodeCount);
        this.nextAndSeens = new NextAndSeenLocal(this.nodeCount);
    }

    private MultiSourceBFS(IdMapping nodeIds, RelationshipIterator relationships, Direction direction, BfsConsumer perNodeAction, ThreadLocal<MultiBitSet32> visits, ThreadLocal<BiMultiBitSet32> nextAndSeens, int ... startNodes) {
        assert (startNodes != null && startNodes.length > 0);
        this.nodeIds = nodeIds;
        this.relationships = relationships;
        this.direction = direction;
        this.perNodeAction = perNodeAction;
        this.startNodes = startNodes;
        this.visits = visits;
        this.nextAndSeens = nextAndSeens;
    }

    private MultiSourceBFS(IdMapping nodeIds, RelationshipIterator relationships, Direction direction, BfsConsumer perNodeAction, int nodeOffset, int sourceNodeCount, ThreadLocal<MultiBitSet32> visits, ThreadLocal<BiMultiBitSet32> nextAndSeens) {
        this.nodeIds = nodeIds;
        this.relationships = relationships;
        this.direction = direction;
        this.perNodeAction = perNodeAction;
        this.startNodes = null;
        this.nodeOffset = nodeOffset;
        this.sourceNodeCount = sourceNodeCount;
        this.visits = visits;
        this.nextAndSeens = nextAndSeens;
    }

    @Override
    public void run(int concurrency, ExecutorService executor) {
        int sourceLength = this.sourceLength();
        int threads = ParallelUtil.threadSize(32, sourceLength);
        Collection<MultiSourceBFS> bfss = this.allSourceBfss(threads);
        if (!ParallelUtil.canRunInParallel(executor)) {
            executor = null;
        }
        ParallelUtil.runWithConcurrency(concurrency, bfss, threads << 2, 100L, TimeUnit.MICROSECONDS, executor);
    }

    @Override
    public void run() {
        int i;
        assert (this.sourceLength() <= 32) : "more than 32 sources not supported";
        SourceNodes sourceNodes = this.startNodes != null ? new SourceNodes(this.startNodes) : new SourceNodes(this.nodeOffset, this.sourceNodeCount);
        MultiBitSet32 visit = this.visits.get();
        BiMultiBitSet32 nextAndSeen = this.nextAndSeens.get();
        if (this.startNodes != null) {
            nextAndSeen.setAuxBits(this.startNodes);
            for (i = 0; i < this.startNodes.length; ++i) {
                visit.setBit(this.startNodes[i], i);
            }
        } else {
            nextAndSeen.setAuxBits(this.nodeOffset, this.sourceNodeCount);
            for (i = 0; i < this.sourceNodeCount; ++i) {
                visit.setBit(i + this.nodeOffset, i);
            }
        }
        int depth = 0;
        do {
            int nodeId = -1;
            while ((nodeId = visit.nextSetNodeId(nodeId + 1)) >= 0) {
                int nodeVisit = visit.get(nodeId);
                assert (nodeVisit != 0);
                this.relationships.forEachRelationship(nodeId, this.direction, (src, tgt, rel) -> {
                    nextAndSeen.union(tgt, nodeVisit);
                    return true;
                });
            }
            ++depth;
            nodeId = -1;
            while ((nodeId = nextAndSeen.nextSetNodeId(nodeId + 1)) >= 0) {
                int D = nextAndSeen.unionDifference(nodeId);
                if (D == 0) continue;
                sourceNodes.reset(D);
                this.perNodeAction.accept(nodeId, depth, sourceNodes);
            }
        } while (nextAndSeen.copyInto(visit));
    }

    private int sourceLength() {
        if (this.startNodes != null) {
            return this.startNodes.length;
        }
        if (this.sourceNodeCount == 0) {
            return this.nodeCount;
        }
        return this.sourceNodeCount;
    }

    private Collection<MultiSourceBFS> allSourceBfss(int threads) {
        if (this.startNodes == null) {
            int sourceLength = this.nodeCount;
            return new ParallelMultiSources(threads, sourceLength){

                @Override
                MultiSourceBFS next(int from, int length) {
                    return new MultiSourceBFS(MultiSourceBFS.this.nodeIds, MultiSourceBFS.this.relationships, MultiSourceBFS.this.direction, MultiSourceBFS.this.perNodeAction, from, length, MultiSourceBFS.this.visits, MultiSourceBFS.this.nextAndSeens);
                }
            };
        }
        final int[] startNodes = this.startNodes;
        int sourceLength = startNodes.length;
        return new ParallelMultiSources(threads, sourceLength){

            @Override
            MultiSourceBFS next(int from, int length) {
                return new MultiSourceBFS(MultiSourceBFS.this.nodeIds, MultiSourceBFS.this.relationships, MultiSourceBFS.this.direction, MultiSourceBFS.this.perNodeAction, MultiSourceBFS.this.visits, MultiSourceBFS.this.nextAndSeens, Arrays.copyOfRange(startNodes, from, from + length));
            }
        };
    }

    public String toString() {
        if (this.startNodes != null && this.startNodes.length > 0) {
            return "MSBFS{" + this.startNodes[0] + " .. " + (this.startNodes[this.startNodes.length - 1] + 1) + " (" + this.startNodes.length + ")}";
        }
        return "MSBFS{" + this.nodeOffset + " .. " + (this.nodeOffset + this.sourceNodeCount) + " (" + this.sourceNodeCount + ")}";
    }

    private static final class NextAndSeenLocal
    extends ThreadLocal<BiMultiBitSet32> {
        private final int nodeCount;

        private NextAndSeenLocal(int nodeCount) {
            this.nodeCount = nodeCount;
        }

        @Override
        protected BiMultiBitSet32 initialValue() {
            return new BiMultiBitSet32(this.nodeCount);
        }
    }

    private static final class VisitLocal
    extends ThreadLocal<MultiBitSet32> {
        private final int nodeCount;

        private VisitLocal(int nodeCount) {
            this.nodeCount = nodeCount;
        }

        @Override
        protected MultiBitSet32 initialValue() {
            return new MultiBitSet32(this.nodeCount);
        }
    }

    private static abstract class ParallelMultiSources
    extends AbstractCollection<MultiSourceBFS>
    implements Iterator<MultiSourceBFS> {
        private final int threads;
        private final int sourceLength;
        private int start = 0;
        private int i = 0;

        private ParallelMultiSources(int threads, int sourceLength) {
            this.threads = threads;
            this.sourceLength = sourceLength;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.threads;
        }

        @Override
        public int size() {
            return this.threads;
        }

        @Override
        public Iterator<MultiSourceBFS> iterator() {
            this.start = 0;
            this.i = 0;
            return this;
        }

        @Override
        public MultiSourceBFS next() {
            int len = Math.min(32, this.sourceLength - this.start);
            MultiSourceBFS bfs = this.next(this.start, len);
            this.start += len;
            ++this.i;
            return bfs;
        }

        abstract MultiSourceBFS next(int var1, int var2);
    }

    private static final class SourceNodes
    implements BfsSources {
        private final int[] sourceNodes;
        private final int maxPos;
        private final int startPos;
        private final int offset;
        private int sourceMask;
        private int pos;

        private SourceNodes(int[] sourceNodes) {
            assert (sourceNodes.length <= 32);
            this.sourceNodes = sourceNodes;
            this.maxPos = sourceNodes.length;
            this.offset = 0;
            this.startPos = -1;
        }

        private SourceNodes(int offset, int length) {
            assert (length <= 32);
            this.sourceNodes = null;
            this.maxPos = length;
            this.offset = offset;
            this.startPos = -1;
        }

        @Override
        public void reset() {
            this.pos = this.startPos;
            this.fetchNext();
        }

        void reset(int sourceMask) {
            this.sourceMask = sourceMask;
            this.reset();
        }

        public boolean hasNext() {
            return this.pos < this.maxPos;
        }

        public int next() {
            int current = this.pos;
            this.fetchNext();
            return this.sourceNodes != null ? this.sourceNodes[current] : current + this.offset;
        }

        @Override
        public int size() {
            return Integer.bitCount(this.sourceMask);
        }

        private void fetchNext() {
            while (++this.pos < this.maxPos && (this.sourceMask & 1 << this.pos) == 0) {
            }
        }
    }
}

