/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.multistepscc;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntIntMap;
import com.carrotsearch.hppc.IntIntScatterMap;
import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.IntStack;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphdb.Direction;

public abstract class AbstractMultiStepTarjan {
    private final Graph graph;
    private BitSet onStack;
    private IntIntMap indices;
    private IntIntMap lowLink;
    private IntStack stack;
    private int index;

    public AbstractMultiStepTarjan(Graph graph) {
        this.graph = graph;
    }

    public AbstractMultiStepTarjan compute(IntSet nodes) {
        this.indices = new IntIntScatterMap(nodes.size());
        this.lowLink = new IntIntScatterMap(nodes.size());
        this.stack = new IntStack(nodes.size());
        this.onStack = new BitSet();
        nodes.forEach(this::strongConnect);
        return this;
    }

    private void reset() {
        this.indices.clear();
        this.lowLink.clear();
        this.onStack.clear();
        this.stack.clear();
        this.index = 0;
    }

    private void strongConnect(int node) {
        if (this.indices.containsKey(node)) {
            return;
        }
        this.lowLink.put(node, this.index);
        this.indices.put(node, this.index);
        ++this.index;
        this.stack.push(node);
        this.onStack.set(node);
        this.graph.forEachRelationship(node, Direction.OUTGOING, this::accept);
        if (this.indices.get(node) == this.lowLink.get(node)) {
            this.relax(node);
        }
    }

    private void relax(int nodeId) {
        int w;
        IntHashSet connected = new IntHashSet();
        do {
            w = this.stack.pop();
            this.onStack.clear(w);
            connected.add(w);
        } while (w != nodeId);
        this.processSCC(nodeId, connected);
    }

    private boolean accept(int source, int target, long edgeId) {
        if (!this.indices.containsKey(target)) {
            this.strongConnect(target);
            this.lowLink.put(source, Math.min(this.lowLink.get(source), this.lowLink.get(target)));
        } else if (this.onStack.get(target)) {
            this.lowLink.put(source, Math.min(this.lowLink.get(source), this.indices.get(target)));
        }
        return true;
    }

    public abstract void processSCC(int var1, IntHashSet var2);
}

