/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.multistepscc;

import com.carrotsearch.hppc.IntScatterSet;
import com.carrotsearch.hppc.IntSet;
import java.util.concurrent.ExecutorService;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.utils.traverse.ParallelLocalQueueBFS;
import org.neo4j.graphdb.Direction;

public class MultiStepFWBW {
    private final Graph graph;
    private final ParallelLocalQueueBFS traverse;
    private int root;

    public MultiStepFWBW(Graph graph, ExecutorService executorService, int concurrency) {
        this.graph = graph;
        this.traverse = new ParallelLocalQueueBFS(graph, executorService, concurrency);
    }

    public IntSet compute(IntSet nodes) {
        this.root = this.pivot(nodes);
        IntScatterSet descendant = new IntScatterSet();
        this.traverse.bfs(this.root, Direction.OUTGOING, nodes::contains, descendant::add).awaitTermination();
        IntScatterSet rootSCC = new IntScatterSet();
        this.traverse.reset().bfs(this.root, Direction.INCOMING, descendant::contains, rootSCC::add).awaitTermination();
        rootSCC.retainAll(descendant);
        return rootSCC;
    }

    public int getRoot() {
        return this.root;
    }

    private int pivot(IntSet set) {
        int product = 0;
        int[] pivot = new int[]{0};
        set.forEach(node -> {
            int p = this.graph.degree(node, Direction.OUTGOING) * this.graph.degree(node, Direction.INCOMING);
            if (p > product) {
                pivot[0] = node;
            }
        });
        return pivot[0];
    }
}

